/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class PatternImageURLTransformer
implements Function<String, String> {
    private final Pattern pattern;
    private final String format;

    public PatternImageURLTransformer(String pattern, String format) {
        this.pattern = Pattern.compile(pattern);
        this.format = format;
    }

    public PatternImageURLTransformer(Pattern pattern, String format) {
        this.pattern = pattern;
        this.format = format;
    }

    @Override
    @Nullable
    public String apply(String input) {
        Matcher matcher = this.pattern.matcher(input);
        if (matcher.matches()) {
            if (matcher.groupCount() > 0) {
                return String.format(this.format, matcher.group(1));
            }
            return String.format(this.format, input);
        }
        return null;
    }
}

