/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.function.Function;
import net.blay09.mods.chattweaks.ChatTweaks;
import net.blay09.mods.chattweaks.chat.emotes.EmoteRegistry;
import net.blay09.mods.chattweaks.chat.emotes.IEmote;
import net.blay09.mods.chattweaks.chat.emotes.IEmoteGroup;
import net.blay09.mods.chattweaks.chat.emotes.IEmoteSource;
import net.blay09.mods.chattweaks.image.renderable.IChatRenderable;
import net.blay09.mods.chattweaks.image.renderable.ImageLoader;

public class ChatTweaksAPI {
    private static final long IMAGE_CACHE_TIME = 604800000L;

    public static IEmoteGroup registerEmoteGroup(String name) {
        return EmoteRegistry.registerEmoteGroup(name);
    }

    public static <T> IEmote<T> registerEmote(String code, IEmoteSource<T> source, T data) {
        return EmoteRegistry.registerEmote(code, source, data);
    }

    public static IChatRenderable loadImage(URI uri, File cacheFile) throws IOException {
        return ImageLoader.loadImage(uri, cacheFile);
    }

    public static void loadEmoteImage(IEmote emote, InputStream inputStream) throws IOException {
        if (!ChatTweaksAPI.loadEmoteImageFromCache(emote)) {
            emote.setImage(ImageLoader.loadImage(inputStream, emote.getImageCacheFile()));
        }
    }

    public static void loadEmoteImage(IEmote emote, URI uri) throws IOException {
        if (!ChatTweaksAPI.loadEmoteImageFromCache(emote)) {
            emote.setImage(ImageLoader.loadImage(uri, emote.getImageCacheFile()));
        }
    }

    public static void registerImageURLTransformer(Function<String, String> urlTransformer) {
        ChatTweaks.registerImageURLTransformer(urlTransformer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadEmoteImageFromCache(IEmote emote) {
        if (emote.getImageCacheFile() == null) return false;
        if (!emote.getImageCacheFile().exists()) return false;
        if (emote.getImageCacheFile().lastModified() - System.currentTimeMillis() >= 604800000L) return false;
        try (FileInputStream in = new FileInputStream(emote.getImageCacheFile());){
            emote.setImage(ImageLoader.loadImage(in));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.err.println("Failed to load emote from cache: " + e.getMessage());
        }
        return false;
    }
}

