/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.chattweaks;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.blay09.mods.chattweaks.ChatManager;
import net.blay09.mods.chattweaks.ChatTweaksAPI;
import net.blay09.mods.chattweaks.ChatTweaksConfig;
import net.blay09.mods.chattweaks.ChatViewManager;
import net.blay09.mods.chattweaks.PatternImageURLTransformer;
import net.blay09.mods.chattweaks.auth.AuthManager;
import net.blay09.mods.chattweaks.chat.ChatChannel;
import net.blay09.mods.chattweaks.chat.ChatMessage;
import net.blay09.mods.chattweaks.chat.ChatView;
import net.blay09.mods.chattweaks.compat.BlurCompat;
import net.blay09.mods.chattweaks.gui.BottomChatRenderer;
import net.blay09.mods.chattweaks.gui.SideChatRenderer;
import net.blay09.mods.chattweaks.gui.chat.GuiChatExt;
import net.blay09.mods.chattweaks.gui.chat.GuiNewChatExt;
import net.blay09.mods.chattweaks.gui.chat.GuiSleepMPExt;
import net.blay09.mods.chattweaks.handler.EmoteTabCompletionHandler;
import net.blay09.mods.chattweaks.handler.HighlightHandler;
import net.blay09.mods.chattweaks.handler.OpenScreenshotFolderHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="chattweaks", name="Chat Tweaks", clientSideOnly=true, guiFactory="net.blay09.mods.chattweaks.gui.config.GuiFactory", acceptedMinecraftVersions="[1.12]")
public class ChatTweaks {
    public static final String MOD_ID = "chattweaks";
    public static final String TEXT_FORMATTING_RGB = "\u00a7#";
    public static final String TEXT_FORMATTING_EMOTE = "\u00a7*";
    public static final int MAX_MESSAGES = 100;
    public static Logger logger;
    @Mod.Instance(value="chattweaks")
    public static ChatTweaks instance;
    public static final KeyBinding keySwitchChatView;
    private Configuration config;
    private GuiNewChatExt persistentChatGUI;
    private SideChatRenderer sideChatRenderer;
    private BottomChatRenderer bottomChatRenderer;
    private AuthManager authManager;
    private List<Function<String, String>> imageURLTransformers = Lists.newArrayList();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File cacheDir;
        logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.sideChatRenderer = new SideChatRenderer();
        MinecraftForge.EVENT_BUS.register((Object)this.sideChatRenderer);
        this.bottomChatRenderer = new BottomChatRenderer();
        MinecraftForge.EVENT_BUS.register((Object)this.bottomChatRenderer);
        MinecraftForge.EVENT_BUS.register((Object)new EmoteTabCompletionHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HighlightHandler());
        MinecraftForge.EVENT_BUS.register((Object)new OpenScreenshotFolderHandler());
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        ChatTweaksConfig.preInitLoad(this.config);
        ChatManager.init();
        this.authManager = new AuthManager();
        this.authManager.load();
        ChatTweaksAPI.registerImageURLTransformer(new PatternImageURLTransformer(".+\\.(?:png|jpg)", "%s"));
        ChatTweaksAPI.registerImageURLTransformer(new PatternImageURLTransformer(".*imgur\\.com/[A-Za-z]+", "%s.png"));
        ChatTweaksAPI.registerImageURLTransformer(new PatternImageURLTransformer(".*gyazo\\.com/[a-z0-9]+", "%s.png"));
        ChatTweaksAPI.registerImageURLTransformer(new PatternImageURLTransformer("(.*twimg\\.com/[^:]+):large", "%s"));
        File configDir = new File(event.getModConfigurationDirectory(), "ChatTweaks");
        if (!configDir.exists() && !configDir.mkdirs()) {
            logger.error("Failed to create ChatTweaks config directory.");
        }
        if (!(cacheDir = new File(Minecraft.func_71410_x().field_71412_D, "ChatTweaks/cache/")).exists() && !cacheDir.mkdirs()) {
            logger.error("Failed to create ChatTweaks cache directory.");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)keySwitchChatView);
        this.persistentChatGUI = new GuiNewChatExt(Minecraft.func_71410_x());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ChatTweaksConfig.postInitLoad(this.config);
        ChatViewManager.load();
        if (this.config.hasChanged()) {
            this.config.save();
        }
        if (Loader.isModLoaded((String)"blur")) {
            BlurCompat.enableBlurCompat();
        }
    }

    @SubscribeEvent
    public void onConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Minecraft.func_71410_x().field_71456_v.field_73840_e = this.persistentChatGUI;
    }

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent event) {
        if (event.getGui() != null) {
            if (event.getGui().getClass() == GuiChat.class) {
                event.setGui((GuiScreen)new GuiChatExt(((GuiChat)event.getGui()).field_146409_v));
            } else if (event.getGui().getClass() == GuiSleepMP.class) {
                event.setGui((GuiScreen)new GuiSleepMPExt());
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID) && "config".equals(event.getConfigID())) {
            ChatViewManager.save();
            ChatTweaksConfig.preInitLoad(this.config);
            ChatTweaksConfig.postInitLoad(this.config);
        }
    }

    public static GuiNewChatExt getChatDisplay() {
        return ChatTweaks.instance.persistentChatGUI;
    }

    public static SideChatRenderer getSideChatHandler() {
        return ChatTweaks.instance.sideChatRenderer;
    }

    public static BottomChatRenderer getBottomChatHandler() {
        return ChatTweaks.instance.bottomChatRenderer;
    }

    public static Configuration getConfig() {
        return ChatTweaks.instance.config;
    }

    public static AuthManager getAuthManager() {
        return ChatTweaks.instance.authManager;
    }

    public static List<Function<String, String>> getImageURLTransformers() {
        return ChatTweaks.instance.imageURLTransformers;
    }

    public static void registerImageURLTransformer(Function<String, String> function) {
        ChatTweaks.instance.imageURLTransformers.add(function);
    }

    public static int colorFromHex(String hex) {
        return Integer.parseInt(hex.startsWith("#") ? hex.substring(1) : hex, 16);
    }

    public static ChatMessage createChatMessage(ITextComponent component) {
        return new ChatMessage(ChatManager.getNextMessageId(), component);
    }

    public static void addChatMessage(ChatMessage chatMessage, @Nullable ChatChannel chatChannel) {
        ChatTweaks.instance.persistentChatGUI.addChatMessage(chatMessage, chatChannel != null ? chatChannel : ChatManager.findChatChannel(chatMessage));
    }

    public static void addChatMessage(ITextComponent component, @Nullable ChatChannel chatChannel) {
        ChatTweaks.addChatMessage(ChatTweaks.createChatMessage(component), chatChannel);
    }

    public static void refreshChat() {
        for (ChatView chatView : ChatViewManager.getViews()) {
            chatView.refresh();
        }
        ChatTweaks.instance.persistentChatGUI.func_146245_b();
    }

    static {
        keySwitchChatView = new KeyBinding("key.chattweaks.switch_chat_view", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.SHIFT, 15, "key.categories.chattweaks");
    }
}

