/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.world.gen;

import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public final class WorldGenHelper {
    @Nullable
    public static BlockPos.MutableBlockPos findGround(World world, BlockPos pos, boolean ignoreLeaves, boolean stopOnFluid, boolean useWorldHeight) {
        return WorldGenHelper.findGround(world, pos, ignoreLeaves, stopOnFluid, useWorldHeight, 8);
    }

    @Nullable
    public static BlockPos.MutableBlockPos findGround(World world, BlockPos pos, boolean ignoreLeaves, boolean stopOnFluid, boolean useWorldHeight, int offset) {
        BlockPos.MutableBlockPos position;
        if (useWorldHeight) {
            pos = world.func_175645_m(pos);
        }
        if ((position = new BlockPos.MutableBlockPos(pos)).func_177956_o() > 0) {
            int yOrigin = position.func_177956_o();
            do {
                IBlockState state = world.func_180495_p((BlockPos)position);
                if (stopOnFluid && (state.func_177230_c() instanceof BlockLiquid || state.func_177230_c() instanceof IFluidBlock)) {
                    return position.func_189536_c(EnumFacing.UP);
                }
                if (state.func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)position) || ignoreLeaves && state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)position)) continue;
                return position.func_189536_c(EnumFacing.UP);
            } while (yOrigin - position.func_177956_o() < 40 && position.func_189536_c(EnumFacing.DOWN).func_177956_o() > 0);
        }
        return null;
    }
}

