/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.world.gen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.blocks.BlockCuisineCrops;
import snownee.cuisine.world.gen.WorldGenHelper;

public class WorldGenGarden {
    public static final List<Block> PLANT_POOL = Lists.newArrayList((Object[])new Block[]{CuisineRegistry.CHINESE_CABBAGE, CuisineRegistry.CORN, CuisineRegistry.CUCUMBER, CuisineRegistry.EGGPLANT, CuisineRegistry.GINGER, CuisineRegistry.GREEN_PEPPER, CuisineRegistry.LEEK, CuisineRegistry.LETTUCE, CuisineRegistry.ONION, CuisineRegistry.PEANUT, CuisineRegistry.RED_PEPPER, CuisineRegistry.SCALLION, CuisineRegistry.SESAME, CuisineRegistry.SICHUAN_PEPPER, CuisineRegistry.SOYBEAN, CuisineRegistry.SPINACH, CuisineRegistry.TOMATO, CuisineRegistry.TURNIP, Blocks.field_150459_bM, Blocks.field_150469_bN, Blocks.field_150464_aj});
    public static final boolean disablePepper;
    public static final boolean disableRice;

    @SubscribeEvent
    public void decorateEvent(DecorateBiomeEvent.Decorate event) {
        World worldIn = event.getWorld();
        if (event.getType() == DecorateBiomeEvent.Decorate.EventType.PUMPKIN && Arrays.binarySearch(CuisineConfig.WORLD_GEN.cropsGenDimensions, worldIn.field_73011_w.getDimension()) >= 0) {
            Random rand = event.getRand();
            BlockPos position = event.getChunkPos().func_180331_a(rand.nextInt(16) + 8, 0, rand.nextInt(16) + 8);
            Biome biome = worldIn.func_180494_b(position);
            int flowers = biome.field_76760_I.field_76802_A;
            if (flowers == -999 && biome.getClass().getName().startsWith("biomesoplenty")) {
                flowers = 1;
            }
            if (!biome.func_76738_d() || biome.func_150559_j() || biome.field_76760_I.field_76802_A < 1 || biome instanceof BiomeOcean || rand.nextDouble() > (double)biome.func_185353_n() || rand.nextInt(200) >= CuisineConfig.WORLD_GEN.cropsGenRate) {
                return;
            }
            BlockPos.MutableBlockPos pos = WorldGenHelper.findGround(worldIn, position, true, true, true);
            if (pos == null) {
                return;
            }
            pos.func_189536_c(EnumFacing.DOWN);
            IBlockState state = worldIn.func_180495_p((BlockPos)pos);
            if (biome.field_76752_A.func_185904_a() == Material.field_151577_b && state.func_177230_c() == biome.field_76752_A.func_177230_c()) {
                Block plant = PLANT_POOL.get(rand.nextInt(PLANT_POOL.size()));
                WorldGenGarden.plant(worldIn, (BlockPos)pos, plant, biome.field_76752_A.func_177230_c(), rand);
                WorldGenGarden.plant(worldIn, pos.func_177972_a(EnumFacing.func_176731_b((int)rand.nextInt(4))), plant, biome.field_76752_A.func_177230_c(), rand);
                WorldGenGarden.plant(worldIn, pos.func_177972_a(EnumFacing.func_176731_b((int)rand.nextInt(4))), plant, biome.field_76752_A.func_177230_c(), rand);
            } else if (!(disableRice || state.func_177230_c() != Blocks.field_150355_j || (state = worldIn.func_180495_p(pos.func_177977_b())).func_185904_a() != Material.field_151578_c && state.func_185904_a() != Material.field_151577_b)) {
                pos.func_189536_c(EnumFacing.UP);
                worldIn.func_180501_a((BlockPos)pos, CuisineRegistry.RICE.withAge(rand.nextInt(CuisineRegistry.RICE.getMaxAge())), 0);
            }
        } else if (!disablePepper && worldIn.field_73011_w.getDimension() == -1) {
            Random rand = event.getRand();
            if (rand.nextInt(4) > 0 || rand.nextInt(100) < CuisineConfig.WORLD_GEN.cropsGenRate) {
                return;
            }
            BlockPos position = event.getChunkPos().func_180331_a(rand.nextInt(16) + 8, rand.nextInt(50) + 33, rand.nextInt(16) + 8);
            BlockPos.MutableBlockPos pos = WorldGenHelper.findGround(worldIn, position, true, true, false, 20);
            if (pos == null) {
                return;
            }
            pos.func_189536_c(EnumFacing.DOWN);
            if (worldIn.func_180495_p((BlockPos)pos).func_177230_c() == Blocks.field_150425_aM) {
                WorldGenGarden.plant(worldIn, (BlockPos)pos, (Block)CuisineRegistry.CHILI, Blocks.field_150425_aM, rand);
            }
        }
    }

    private static void plant(World world, BlockPos pos, Block block, Block replacedBlock, Random rand) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == replacedBlock) {
            if (block instanceof BlockCuisineCrops) {
                BlockCuisineCrops blockCuisineCrops = (BlockCuisineCrops)block;
                if (blockCuisineCrops.getPlantType((IBlockAccess)world, pos) == EnumPlantType.Crop) {
                    world.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P(), 0);
                }
                if (world.func_180495_p(pos = pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                    world.func_180501_a(pos, blockCuisineCrops.withAge(block == CuisineRegistry.CORN ? 0 : rand.nextInt(blockCuisineCrops.getMaxAge())), 0);
                }
            } else if (block instanceof BlockCrops) {
                world.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P(), 0);
                BlockCrops blockCrops = (BlockCrops)block;
                pos = pos.func_177984_a();
                if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                    world.func_180501_a(pos, blockCrops.func_185528_e(rand.nextInt(blockCrops.func_185526_g())), 0);
                }
            }
        }
    }

    static {
        HashSet ids = Sets.newHashSet((Object[])CuisineConfig.WORLD_GEN.disableCropGenIdList);
        disablePepper = ids.contains("cuisine:chili_pepper");
        disableRice = ids.contains("cuisine:rice");
        PLANT_POOL.removeIf($ -> ids.contains($.getRegistryName().toString()));
    }
}

