/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.world.gen;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.blocks.BlockModSapling;
import snownee.cuisine.world.feature.WorldFeatureCitrusGenusTree;
import snownee.cuisine.world.gen.WorldGenHelper;

public class WorldGenCitrusTrees {
    private static final BlockModSapling.Type[] TYPES = new BlockModSapling.Type[]{BlockModSapling.Type.CITRON, BlockModSapling.Type.CITRON, BlockModSapling.Type.CITRON, BlockModSapling.Type.LIME, BlockModSapling.Type.LIME, BlockModSapling.Type.LIME, BlockModSapling.Type.MANDARIN, BlockModSapling.Type.MANDARIN, BlockModSapling.Type.MANDARIN, BlockModSapling.Type.LIME, BlockModSapling.Type.LIME, BlockModSapling.Type.LEMON, BlockModSapling.Type.LEMON, BlockModSapling.Type.ORANGE, BlockModSapling.Type.ORANGE, BlockModSapling.Type.GRAPEFRUIT};

    @SubscribeEvent
    public void decorateEvent(DecorateBiomeEvent.Decorate event) {
        World world = event.getWorld();
        if (event.getType() == DecorateBiomeEvent.Decorate.EventType.TREE && Arrays.binarySearch(CuisineConfig.WORLD_GEN.fruitTreesGenDimensions, world.field_73011_w.getDimension()) >= 0 && event.getRand().nextInt(200) < CuisineConfig.WORLD_GEN.fruitTreesGenRate) {
            Random rand = event.getRand();
            BlockPos pos = event.getChunkPos().func_180331_a(rand.nextInt(16) + 8, 0, rand.nextInt(16) + 8);
            Biome biome = world.func_180494_b(pos);
            if (!biome.func_76738_d() || biome.func_150559_j() || biome.field_76760_I.field_76832_z < 2 || biome.field_76760_I.field_76832_z > 10 || biome instanceof BiomeSwamp || rand.nextDouble() > (double)biome.func_185353_n()) {
                return;
            }
            if ((pos = WorldGenHelper.findGround(world, pos, false, true, true)) != null && pos.func_177956_o() < 100 && CuisineRegistry.SAPLING.func_176196_c(world, pos)) {
                BlockModSapling.Type type = TYPES[rand.nextInt(TYPES.length)];
                WorldFeatureCitrusGenusTree generator = new WorldFeatureCitrusGenusTree(false, type, true);
                generator.func_180709_b(world, rand, pos);
            }
        }
    }
}

