/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.world.gen;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.world.feature.WorldFeatureBamboo;
import snownee.cuisine.world.gen.WorldGenHelper;

public class WorldGenBamboo {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void decorateEvent(DecorateBiomeEvent.Decorate event) {
        World worldIn = event.getWorld();
        if (event.getType() == DecorateBiomeEvent.Decorate.EventType.TREE && Arrays.binarySearch(CuisineConfig.WORLD_GEN.bamboosGenDimensions, worldIn.field_73011_w.getDimension()) >= 0) {
            Random rand = event.getRand();
            BlockPos position = event.getChunkPos().func_180331_a(rand.nextInt(16) + 8, 128, rand.nextInt(16) + 8);
            Biome biome = worldIn.func_180494_b(position);
            if (biome.func_185355_j() > 0.4f || biome.func_150559_j() || biome.func_76727_i() < 0.5f || biome instanceof BiomeOcean || biome instanceof BiomeSwamp || rand.nextInt(200) >= CuisineConfig.WORLD_GEN.bamboosGenRate || rand.nextDouble() > (double)biome.func_185353_n()) {
                return;
            }
            if ((position = WorldGenHelper.findGround(worldIn, position, true, true, true)) == null) {
                return;
            }
            int count = 15 + rand.nextInt(10);
            WorldFeatureBamboo generator = new WorldFeatureBamboo(false);
            while (--count != 0) {
                BlockPos pos = position.func_177982_a(rand.nextInt(13) - 6, 3, rand.nextInt(13) - 6);
                IBlockState iblockstate = worldIn.func_180495_p(pos);
                while ((iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, pos) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, pos)) && pos.func_177956_o() + 3 >= position.func_177956_o()) {
                    pos = pos.func_177977_b();
                    iblockstate = worldIn.func_180495_p(pos);
                }
                pos = pos.func_177984_a();
                if (count > 7) {
                    generator.func_180709_b(worldIn, rand, pos);
                    continue;
                }
                if (!CuisineRegistry.BAMBOO_PLANT.func_176196_c(worldIn, pos)) continue;
                worldIn.func_175656_a(pos, CuisineRegistry.BAMBOO_PLANT.func_176223_P());
            }
        }
    }
}

