/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.world.feature;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.blocks.BlockModLeaves;
import snownee.cuisine.blocks.BlockModSapling;
import snownee.cuisine.tiles.TileFruitTree;

public class WorldFeatureCitrusGenusTree
extends WorldGenAbstractTree {
    private final BlockModSapling.Type type;
    private final boolean flower;

    public WorldFeatureCitrusGenusTree(boolean notifyUpdate, BlockModSapling.Type type, boolean flower) {
        super(notifyUpdate);
        this.type = type;
        this.flower = flower;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = 5 + rand.nextInt(2);
        boolean flag = true;
        if (position.func_177956_o() < 1 || position.func_177956_o() + i + 1 > worldIn.func_72800_K()) {
            return false;
        }
        for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
            int k = 1;
            if (j == position.func_177956_o()) {
                k = 0;
            }
            if (j >= position.func_177956_o() + 1 + i - 2) {
                k = 2;
            }
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                    if (j >= 0 && j < worldIn.func_72800_K()) {
                        if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        IBlockState state = worldIn.func_180495_p(position.func_177977_b());
        if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, position.func_177977_b(), EnumFacing.UP, (IPlantable)CuisineRegistry.SAPLING) && position.func_177956_o() < worldIn.func_72800_K() - i - 1) {
            IBlockState wood = CuisineRegistry.LOG.func_176223_P();
            IBlockState leaves = WorldFeatureCitrusGenusTree.getLeavesFromType(this.type);
            state.func_177230_c().onPlantGrow(state, worldIn, position.func_177977_b(), position);
            for (int i3 = position.func_177956_o() - 3 + i; i3 <= position.func_177956_o() + i; ++i3) {
                int i4 = i3 - (position.func_177956_o() + i);
                int j1 = 1 - i4 / 2;
                for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1; ++k1) {
                    int l1 = k1 - position.func_177958_n();
                    for (int i2 = position.func_177952_p() - j1; i2 <= position.func_177952_p() + j1; ++i2) {
                        BlockPos blockpos;
                        int j2 = i2 - position.func_177952_p();
                        if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i4 == 0) || !(state = worldIn.func_180495_p(blockpos = new BlockPos(k1, i3, i2))).func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos) && state.func_185904_a() != Material.field_151582_l) continue;
                        if (this.flower && rand.nextInt(5) == 0) {
                            this.func_175903_a(worldIn, blockpos, leaves.func_177226_a((IProperty)BlockModLeaves.AGE, (Comparable)Integer.valueOf(2)));
                            continue;
                        }
                        this.func_175903_a(worldIn, blockpos, leaves);
                    }
                }
            }
            for (int j3 = 0; j3 < i; ++j3) {
                BlockPos upN = position.func_177981_b(j3);
                state = worldIn.func_180495_p(upN);
                if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, upN) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, upN) && state.func_185904_a() != Material.field_151582_l) continue;
                this.func_175903_a(worldIn, upN, wood);
            }
            BlockPos upI = position.func_177981_b(i);
            this.func_175903_a(worldIn, upI, leaves.func_177226_a((IProperty)BlockModLeaves.CORE, (Comparable)Boolean.valueOf(true)));
            TileEntity tile = worldIn.func_175625_s(upI);
            if (tile instanceof TileFruitTree) {
                ((TileFruitTree)tile).type = this.type;
            }
            return true;
        }
        return false;
    }

    private static IBlockState getLeavesFromType(BlockModSapling.Type type) {
        switch (type) {
            case CITRON: {
                return CuisineRegistry.LEAVES_CITRON.func_176223_P();
            }
            case GRAPEFRUIT: {
                return CuisineRegistry.LEAVES_GRAPEFRUIT.func_176223_P();
            }
            case LEMON: {
                return CuisineRegistry.LEAVES_LEMON.func_176223_P();
            }
            case LIME: {
                return CuisineRegistry.LEAVES_LIME.func_176223_P();
            }
            case MANDARIN: {
                return CuisineRegistry.LEAVES_MANDARIN.func_176223_P();
            }
            case ORANGE: {
                return CuisineRegistry.LEAVES_ORANGE.func_176223_P();
            }
        }
        return CuisineRegistry.LEAVES_POMELO.func_176223_P();
    }
}

