/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.util;

import java.text.MessageFormat;
import net.minecraftforge.client.MinecraftForgeClient;
import snownee.cuisine.Cuisine;

public class I18nUtil {
    public static String getFullKey(String key) {
        return "cuisine." + key;
    }

    public static boolean canTranslate(String key) {
        return Cuisine.sidedDelegate.canTranslate(I18nUtil.getFullKey(key));
    }

    public static String translate(String key, Object ... parameters) {
        return Cuisine.sidedDelegate.translate(I18nUtil.getFullKey(key), parameters);
    }

    public static String translate(String key) {
        return Cuisine.sidedDelegate.translate(I18nUtil.getFullKey(key));
    }

    public static String translateWithEscape(String key, Object ... parameters) {
        return I18nUtil.translate(key, parameters).replaceAll("\\\\n", "\n");
    }

    public static String translateWithFormat(String key, Object ... args) {
        try {
            return new MessageFormat(I18nUtil.translate(key), MinecraftForgeClient.getLocale()).format(args);
        }
        catch (IllegalArgumentException e) {
            Cuisine.logger.debug("Failed to format {} with arguments {}. Exception: {}", (Object)key, (Object)args, (Object)e);
            return key;
        }
    }
}

