/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CookingStrategy;
import snownee.cuisine.api.CookingStrategyProvider;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.CulinarySkillPoint;
import snownee.cuisine.api.FoodContainer;
import snownee.cuisine.api.HeatHandler;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.Seasoning;
import snownee.cuisine.api.Spice;
import snownee.cuisine.api.util.SkillUtil;
import snownee.cuisine.internal.CuisinePersistenceCenter;
import snownee.cuisine.internal.food.Dish;
import snownee.cuisine.items.ItemSpiceBottle;
import snownee.cuisine.network.PacketCustomEvent;
import snownee.cuisine.tiles.FuelHeatHandler;
import snownee.cuisine.tiles.PacketIncrementalWokUpdate;
import snownee.cuisine.tiles.PacketWokSeasoningsUpdate;
import snownee.cuisine.tiles.TileFirePit;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.network.NetworkChannel;
import snownee.kiwi.network.PacketMod;

public class TileWok
extends TileFirePit
implements CookingVessel {
    private Status status = Status.IDLE;
    private Dish.Builder builder;
    private transient Dish completedDish;
    public byte actionCycle = 0;
    final transient Map<Ingredient, ItemStack> ingredientsForRendering = new LinkedHashMap<Ingredient, ItemStack>(8);
    @Nullable
    public SeasoningInfo seasoningInfo;
    private boolean shouldRefresh = false;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.status == Status.WORKING) {
            if (this.builder != null && this.heatHandler.getHeatPower() > 0.0f && this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.builder.apply(new Heating(this.heatHandler), this);
                if (!this.builder.getIngredients().isEmpty()) {
                    this.requiresRefresh();
                }
            }
            if (this.shouldRefresh && this.field_145850_b.func_82737_E() % 5L == 0L) {
                this.refresh();
                this.shouldRefresh = false;
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void onActivated(EntityPlayerMP playerIn, EnumHand hand, EnumFacing facing) {
        ItemStack heldThing = playerIn.func_184586_b(hand);
        switch (this.status) {
            case IDLE: {
                boolean isIngredient;
                boolean bl = isIngredient = heldThing.func_77973_b() instanceof ItemSpiceBottle || CulinaryHub.API_INSTANCE.findIngredient(heldThing) != null;
                if (!isIngredient && !FuelHeatHandler.isFuel(heldThing, true)) break;
                if (isIngredient) {
                    this.builder = Dish.Builder.create();
                }
                boolean result = this.cook(playerIn, hand, heldThing, facing);
                if (isIngredient && result) {
                    this.status = Status.WORKING;
                    break;
                }
                this.builder = null;
                break;
            }
            case WORKING: {
                if (this.cook(playerIn, hand, heldThing, facing)) break;
                if (heldThing.func_77973_b() == Item.func_150898_a((Block)CuisineRegistry.PLACED_DISH) && !this.builder.getIngredients().isEmpty()) {
                    Optional<Dish> result = this.builder.build(this, (EntityPlayer)playerIn);
                    if (!result.isPresent()) {
                        return;
                    }
                    this.completedDish = result.get();
                    SkillUtil.increasePoint((EntityPlayer)playerIn, CulinarySkillPoint.EXPERTISE, (int)((float)this.completedDish.getFoodLevel() * this.completedDish.getSaturationModifier()));
                    SkillUtil.increasePoint((EntityPlayer)playerIn, CulinarySkillPoint.PROFICIENCY, 1);
                    if (!playerIn.func_184812_l_()) {
                        heldThing.func_190918_g(1);
                    }
                    playerIn.openGui((Object)Cuisine.getInstance(), 1, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                    break;
                }
                CookingStrategy strategy = this.determineCookingStrategy(heldThing);
                if (strategy == null) {
                    return;
                }
                double limit = this.builder.getMaxIngredientLimit();
                if (!SkillUtil.hasPlayerLearnedSkill((EntityPlayer)playerIn, CulinaryHub.CommonSkills.BIGGER_SIZE)) {
                    limit *= 0.75;
                }
                if ((double)this.builder.getIngredients().size() > limit) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(I18nUtil.getFullKey("gui.wok_size_too_large"), new Object[0]), true);
                    return;
                }
                this.builder.apply(strategy, this);
                if (this.getHeatHandler().getLevel() > 0 && this.func_145831_w().field_73012_v.nextInt(5) == 0) {
                    SkillUtil.increasePoint((EntityPlayer)playerIn, CulinarySkillPoint.PROFICIENCY, 1);
                }
                NetworkChannel.INSTANCE.sendToDimension((PacketMod)new PacketCustomEvent(3, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()), this.func_145831_w().field_73011_w.getDimension());
            }
        }
    }

    private boolean cook(EntityPlayerMP player, EnumHand hand, ItemStack heldThing, EnumFacing facing) {
        if (heldThing.func_77973_b() instanceof ItemSpiceBottle) {
            FluidStack fluid;
            if (CuisineRegistry.SPICE_BOTTLE.hasFluid(heldThing) && ((fluid = CuisineRegistry.SPICE_BOTTLE.getFluidHandler(heldThing).drain(Integer.MAX_VALUE, false)) == null || fluid.amount < 100)) {
                return false;
            }
            Spice spice = CuisineRegistry.SPICE_BOTTLE.getSpice(heldThing);
            if (spice != null) {
                if (!player.func_184812_l_()) {
                    CuisineRegistry.SPICE_BOTTLE.consume(heldThing, 1);
                }
                Seasoning seasoning = new Seasoning(spice);
                this.builder.addSeasoning((EntityPlayer)player, seasoning, this);
                this.refreshSeasoningInfo();
                return true;
            }
            return false;
        }
        Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(heldThing);
        if (ingredient != null) {
            if (!SkillUtil.hasPlayerLearnedSkill((EntityPlayer)player, CulinaryHub.CommonSkills.BIGGER_SIZE) && (double)(this.builder.getIngredients().size() + 1) > (double)this.builder.getMaxIngredientLimit() * 0.75) {
                return false;
            }
            if (this.builder.addIngredient((EntityPlayer)player, ingredient, this)) {
                ItemStack newStack = ItemHandlerHelper.copyStackWithSize((ItemStack)heldThing, (int)1);
                if (!player.func_184812_l_()) {
                    heldThing.func_190918_g(1);
                }
                this.ingredientsForRendering.put(ingredient, newStack);
                NetworkChannel.INSTANCE.sendToAll((PacketMod)new PacketIncrementalWokUpdate(this.func_174877_v(), ingredient, newStack));
                return true;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation(I18nUtil.getFullKey("gui.cannot_add_more"), new Object[0]), true);
            return false;
        }
        if (FuelHeatHandler.isFuel(heldThing, true)) {
            ItemStack remain = this.heatHandler.addFuel(heldThing);
            if (!player.func_184812_l_()) {
                player.func_184611_a(hand, remain);
            }
            this.refresh();
            return true;
        }
        return false;
    }

    public Map<Ingredient, ItemStack> getWokContents() {
        return Collections.unmodifiableMap(this.ingredientsForRendering);
    }

    public void refreshSeasoningInfo() {
        List<Seasoning> seasonings;
        if (this.builder == null) {
            return;
        }
        if (this.seasoningInfo == null) {
            this.seasoningInfo = new SeasoningInfo();
        }
        if (!(seasonings = this.builder.getSeasonings()).isEmpty()) {
            Seasoning seasoning = null;
            int a = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            int size = 0;
            for (Seasoning s : seasonings) {
                if (!s.getSpice().isLiquid(s)) continue;
                int color = s.getSpice().getColorCode();
                a += s.getSize() * (color >> 24 & 0xFF);
                r += s.getSize() * (color >> 16 & 0xFF);
                g += s.getSize() * (color >> 8 & 0xFF);
                b += s.getSize() * (color & 0xFF);
                size += s.getSize();
                if (seasoning != null && seasoning.getSize() >= s.getSize()) continue;
                seasoning = s;
            }
            if (seasoning == null) {
                this.seasoningInfo.volume = 0;
            } else if (seasoning.hasKeyword("water") && seasoning.getSize() == size) {
                this.seasoningInfo.volume = size;
                this.seasoningInfo.color = -11773999;
            } else {
                int color = seasoning.getSpice().getColorCode();
                a += seasoning.getSize() * (color >> 24 & 0xFF);
                r += seasoning.getSize() * (color >> 16 & 0xFF);
                g += seasoning.getSize() * (color >> 8 & 0xFF);
                b += seasoning.getSize() * (color & 0xFF);
                this.seasoningInfo.volume = size;
                this.seasoningInfo.color = (a /= (size += seasoning.getSize())) << 24 | (r /= size) << 16 | (g /= size) << 8 | (b /= size);
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            NetworkChannel.INSTANCE.sendToAll((PacketMod)new PacketWokSeasoningsUpdate(this.func_174877_v(), this.seasoningInfo));
        }
    }

    @Nullable
    private CookingStrategy determineCookingStrategy(ItemStack heldItem) {
        Item item = heldItem.func_77973_b();
        if (item instanceof CookingStrategyProvider) {
            return ((CookingStrategyProvider)item).getCookingStrategy(heldItem);
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        Status status = this.status = compound.func_74767_n("status") ? Status.WORKING : Status.IDLE;
        if (compound.func_150297_b("dish", 10)) {
            this.builder = Dish.Builder.fromNBT(compound.func_74775_l("dish"));
            this.refreshSeasoningInfo();
        }
        NBTTagList items = compound.func_150295_c("rendering", 10);
        for (NBTBase tag : items) {
            NBTTagCompound tagCompound;
            if (!(tag instanceof NBTTagCompound) || !(tagCompound = (NBTTagCompound)tag).func_150297_b("ingredient", 10)) continue;
            this.ingredientsForRendering.put(CuisinePersistenceCenter.deserializeIngredient(tagCompound.func_74775_l("ingredient")), new ItemStack(tagCompound.func_74775_l("item")));
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("status", this.status == Status.WORKING);
        if (this.builder != null) {
            compound.func_74782_a("dish", (NBTBase)Dish.Builder.toNBT(this.builder));
        }
        NBTTagList map = new NBTTagList();
        for (Map.Entry<Ingredient, ItemStack> entry : this.ingredientsForRendering.entrySet()) {
            NBTTagCompound tagEntry = new NBTTagCompound();
            tagEntry.func_74782_a("ingredient", (NBTBase)CuisinePersistenceCenter.serialize(entry.getKey()));
            tagEntry.func_74782_a("item", (NBTBase)entry.getValue().serializeNBT());
            map.func_74742_a((NBTBase)tagEntry);
        }
        compound.func_74782_a("rendering", (NBTBase)map);
        return super.func_189515_b(compound);
    }

    @Override
    @Nonnull
    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        if (this.builder != null && !this.builder.getIngredients().isEmpty()) {
            int[] donenesses = new int[this.builder.getIngredients().size()];
            int i = 0;
            for (Ingredient ingredient : this.builder.getIngredients()) {
                donenesses[i] = ingredient.getDoneness();
                ++i;
            }
            data.func_74783_a("donenesses", donenesses);
        }
        return super.writePacketData(data);
    }

    @Override
    protected void readPacketData(NBTTagCompound data) {
        int[] donenesses;
        if (data.func_150297_b("donenesses", 11) && (donenesses = data.func_74759_k("donenesses")).length == this.ingredientsForRendering.size()) {
            int i = 0;
            for (Map.Entry<Ingredient, ItemStack> entry : this.ingredientsForRendering.entrySet()) {
                entry.getKey().setDoneness(donenesses[i]);
                if (entry.getValue().func_77973_b() == CuisineRegistry.INGREDIENT) {
                    entry.getValue().func_77978_p().func_74768_a("doneness", donenesses[i]);
                }
                if (this.seasoningInfo != null && this.seasoningInfo.volume < 2 && donenesses[i] > 130 && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                    float f = (float)((double)this.field_145850_b.field_73012_v.nextFloat() * Math.PI * 2.0);
                    double x = (double)MathHelper.func_76126_a((float)f) * 0.1;
                    double y = (double)this.field_174879_c.func_177956_o() + 0.2 + this.field_145850_b.field_73012_v.nextDouble() * 0.05;
                    double z = (double)MathHelper.func_76134_b((float)f) * 0.1;
                    this.field_145850_b.func_190523_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), (double)this.field_174879_c.func_177958_n() + 0.5 + x, y, (double)this.field_174879_c.func_177952_p() + 0.5 + z, 0.0, 0.0, 0.0, new int[0]);
                }
                ++i;
            }
        }
        super.readPacketData(data);
    }

    @Override
    public Optional<ItemStack> serve() {
        if (this.status == Status.IDLE || this.builder == null) {
            return Optional.empty();
        }
        ItemStack stack = new ItemStack((Item)CuisineRegistry.DISH);
        FoodContainer container = (FoodContainer)stack.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container == null) {
            throw new NullPointerException("Null FoodContainer");
        }
        container.set(this.completedDish);
        this.builder = null;
        this.completedDish = null;
        this.status = Status.IDLE;
        this.ingredientsForRendering.clear();
        NetworkChannel.INSTANCE.sendToAll((PacketMod)new PacketIncrementalWokUpdate(this.func_174877_v(), null, ItemStack.field_190927_a));
        return Optional.of(stack);
    }

    public void requiresRefresh() {
        this.shouldRefresh = true;
    }

    static {
        NetworkChannel.INSTANCE.register(PacketIncrementalWokUpdate.class);
        NetworkChannel.INSTANCE.register(PacketWokSeasoningsUpdate.class);
    }

    static final class Heating
    implements CookingStrategy<Dish.Builder> {
        private HeatHandler heatHandler;
        private Dish.Builder builder;

        Heating(HeatHandler heatHandler) {
            this.heatHandler = heatHandler;
        }

        @Override
        public void beginCook(Dish.Builder food) {
            this.builder = food;
        }

        @Override
        public void preCook(Seasoning seasoning, CookingVessel vessel) {
        }

        @Override
        public void cook(Ingredient ingredient, CookingVessel vessel) {
            if (this.heatHandler.getHeatPower() <= 0.0f) {
                return;
            }
            double progress = ingredient.getMaterial().getBoilHeat() <= this.heatHandler.getHeat() ? Math.pow(ingredient.getMaterial().getBoilHeat() - this.heatHandler.getHeat(), 2.0) / Math.pow(ingredient.getMaterial().getBoilHeat(), 2.0) + 1.0 : 1.0 - Math.pow(ingredient.getMaterial().getBoilHeat() - this.heatHandler.getHeat(), 2.0) / Math.pow(ingredient.getMaterial().getBoilHeat(), 2.0);
            boolean enoughWater = this.builder.getWaterAmount() >= 200 || this.builder.getWaterAmount() / this.builder.getIngredients().size() >= 100;
            int newDoneness = ingredient.getDoneness() + MathHelper.func_76128_c((double)MathHelper.func_151237_a((double)progress, (double)0.0, (double)ingredient.getMaterial().getBoilTime()));
            if (!enoughWater || newDoneness <= 110) {
                ingredient.setDoneness(newDoneness);
            }
        }

        @Override
        public void postCook(Dish.Builder food, CookingVessel vessel) {
        }

        @Override
        public void endCook() {
        }
    }

    public static class SeasoningInfo {
        public int volume;
        public int color;
    }

    public static enum Status {
        IDLE,
        WORKING;

    }
}

