/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.energy.CapabilityEnergy;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.tiles.TileBasin;
import snownee.kiwi.handler.Battery;
import snownee.kiwi.tile.TileBase;

public class TileSqueezer
extends TileBase
implements ITickable {
    private static final float OFFSET_LIMIT = 0.78125f;
    private static final int EXTENDING_UNIT_LENGTH = 25;
    private static final int EXTRACTING_UNIT_LENGTH = 10;
    private static final ResourceLocation STATE_MACHINE = new ResourceLocation("cuisine", "asms/squeezer.json");
    private final IAnimationStateMachine stateMachine;
    private final TimeValues.VariableValue extensionOffset = new TimeValues.VariableValue(0.0f);
    private int extensionProgress;
    private State state = State.EXTRACTED;
    private boolean isInWorkCycle = false;
    private final Battery battery;

    public TileSqueezer() {
        this.stateMachine = Cuisine.sidedDelegate.loadAnimationStateMachine(STATE_MACHINE, (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"offset", (Object)this.extensionOffset));
        this.battery = CuisineConfig.GENERAL.squeezerUsesFE > 0 ? new Battery(CuisineConfig.GENERAL.squeezerUsesFE * 50, CuisineConfig.GENERAL.squeezerUsesFE, 0){

            protected void onEnergyChanged() {
                TileSqueezer.this.refresh();
            }
        } : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_73660_a() {
        TileEntity tile;
        boolean triggered = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (this.battery != null) {
            boolean bl = triggered = !triggered;
        }
        if (this.battery == null) {
            if (triggered) {
                if (this.state == State.EXTRACTED || this.state == State.EXTRACTING) {
                    this.isInWorkCycle = this.state == State.EXTRACTED;
                    this.state = State.EXTENDING;
                    this.animationTransition("moving");
                }
            } else if (this.state == State.EXTENDED || this.state == State.EXTENDING) {
                this.state = State.EXTRACTING;
                this.animationTransition("moving");
            }
        } else {
            if (!triggered) return;
            if ((this.state == State.EXTRACTED || this.state == State.EXTENDING) && this.battery.getEnergyStored() < CuisineConfig.GENERAL.squeezerUsesFE) {
                return;
            }
            if (this.state == State.EXTENDED) {
                this.state = State.EXTRACTING;
                this.animationTransition("moving");
            } else if (this.state == State.EXTRACTED) {
                tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
                if (!(tile instanceof TileBasin)) return;
                TileBasin tileBasin = (TileBasin)tile;
                tileBasin.process(Processing.SQUEEZING, tileBasin.stacks.getStackInSlot(0), true);
                if (tileBasin.squeezingFailed) {
                    return;
                }
                this.isInWorkCycle = true;
                this.state = State.EXTENDING;
                this.animationTransition("moving");
            }
        }
        if (this.state == State.EXTENDING) {
            this.extensionProgress += 25;
            if (this.extensionProgress >= 100) {
                this.extensionProgress = 100;
                this.state = State.EXTENDED;
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() / 4.0f + 0.6f);
                }
            }
        } else if (this.state == State.EXTRACTING) {
            this.extensionProgress -= 10;
            if (this.extensionProgress <= 0) {
                this.extensionProgress = 0;
                if (this.field_145850_b.field_72995_K) {
                    if (!"extracted".equals(this.stateMachine.currentState())) {
                        this.animationTransition("extracted");
                    }
                } else {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() / 4.0f + 0.6f);
                }
                this.state = State.EXTRACTED;
            }
        }
        if (this.state == State.EXTENDED && this.isInWorkCycle) {
            this.isInWorkCycle = false;
            if (!this.field_145850_b.field_72995_K && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof TileBasin) {
                TileBasin basin = (TileBasin)tile;
                basin.process(Processing.SQUEEZING, basin.stacks.getStackInSlot(0), false);
                if (this.battery != null) {
                    this.battery.setEnergy(this.battery.getEnergyStored() - CuisineConfig.GENERAL.squeezerUsesFE);
                }
            }
        }
        this.updateOffset();
    }

    private void animationTransition(String newStateName) {
        if (this.field_145850_b.field_72995_K) {
            this.stateMachine.transition(newStateName);
        }
    }

    private void updateOffset() {
        if (this.field_145850_b.field_72995_K) {
            this.extensionOffset.setValue(((float)this.extensionProgress + Animation.getPartialTickTime()) / 100.0f * 0.78125f);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this.battery != null) {
            this.battery.readFromNBT(compound);
        }
        this.extensionProgress = compound.func_74762_e("Extension");
        this.state = State.values()[compound.func_74762_e("State")];
        this.isInWorkCycle = compound.func_74767_n("WorkCycle");
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.state != State.EXTRACTED) {
            this.updateOffset();
            if (!"moving".equals(this.stateMachine.currentState())) {
                this.stateMachine.transition("moving");
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.battery != null) {
            this.battery.writeToNBT(compound);
        }
        compound.func_74768_a("Extension", this.extensionProgress);
        compound.func_74768_a("State", this.state.ordinal());
        compound.func_74757_a("WorkCycle", this.isInWorkCycle);
        return super.func_189515_b(compound);
    }

    protected void readPacketData(NBTTagCompound data) {
        if (this.battery != null) {
            this.battery.readFromNBT(data);
        }
        this.extensionProgress = data.func_74762_e("Extension");
        this.state = State.values()[data.func_74762_e("State")];
    }

    @Nonnull
    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        if (this.battery != null) {
            this.battery.writeToNBT(data);
        }
        data.func_74768_a("Extension", this.extensionProgress);
        data.func_74768_a("State", this.state.ordinal());
        return data;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityAnimation.ANIMATION_CAPABILITY || capability == CapabilityEnergy.ENERGY && this.battery != null || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.stateMachine);
        }
        if (capability == CapabilityEnergy.ENERGY && this.battery != null) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.battery);
        }
        return (T)super.getCapability(capability, facing);
    }

    private static enum State {
        EXTRACTED,
        EXTENDING,
        EXTENDED,
        EXTRACTING;

    }
}

