/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.CulinarySkillPoint;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.process.Grinding;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.api.util.SkillUtil;
import snownee.cuisine.items.ItemIngredient;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.tile.TileInventoryBase;

public class TileMortar
extends TileInventoryBase {
    private int processTime = 0;
    public boolean pestle = false;
    private Grinding recipe;
    private boolean makingPaste;

    public TileMortar() {
        super(5);
    }

    public void process(EntityPlayer player) {
        boolean bl = this.pestle = !this.pestle;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.pestle) {
            return;
        }
        ++this.processTime;
        if (this.recipe != null) {
            if (this.processTime >= this.recipe.getStep()) {
                this.processTime = 0;
                StacksUtil.spawnItemStack(this.field_145850_b, this.func_174877_v(), this.recipe.getOutput().func_77946_l(), true);
                this.recipe.consume((IItemHandler)this.stacks);
                this.recipe = null;
                SkillUtil.increasePoint(player, CulinarySkillPoint.EXPERTISE, 1);
            }
        } else if (this.makingPaste) {
            if (this.processTime >= 5) {
                this.processTime = 0;
                ItemStack input = this.stacks.getStackInSlot(0);
                Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(this.stacks.getStackInSlot(0));
                if (ingredient != null && ingredient.getForm() != Form.PASTE && ingredient.getForm() != Form.JUICE && ingredient.getMaterial().isValidForm(Form.PASTE)) {
                    Ingredient newIngredient = ingredient.copy();
                    newIngredient.setForm(Form.PASTE);
                    ItemStack output = ItemIngredient.make(newIngredient);
                    StacksUtil.spawnItemStack(this.field_145850_b, this.func_174877_v(), output, true);
                    this.recipe = null;
                    input.func_190918_g(1);
                    SkillUtil.increasePoint(player, CulinarySkillPoint.PROFICIENCY, 3);
                }
                this.makingPaste = false;
            }
        } else {
            this.recipe = Processing.GRINDING.findRecipe(this.stacks.getStacks().toArray(new Object[5]));
            if (this.recipe == null) {
                Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(this.stacks.getStackInSlot(0));
                if (ingredient != null && ingredient.getForm() != Form.PASTE && ingredient.getForm() != Form.JUICE && ingredient.getMaterial().isValidForm(Form.PASTE)) {
                    this.makingPaste = true;
                } else {
                    this.processTime = 0;
                }
            }
        }
    }

    public ItemStack insertItem(ItemStack stack) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)this.stacks, (ItemStack)stack, (boolean)false);
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pestle = compound.func_74767_n("Pestle");
        this.processTime = compound.func_74762_e("ProcessTime");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("ProcessTime", this.processTime);
        compound.func_74757_a("Pestle", this.pestle);
        return compound;
    }

    @Nonnull
    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        data.func_74757_a("Pestle", this.pestle);
        data.func_74768_a("ProcessTime", this.processTime);
        return super.writePacketData(data);
    }

    protected void readPacketData(NBTTagCompound data) {
        super.readPacketData(data);
        this.pestle = data.func_74767_n("Pestle");
        this.processTime = data.func_74762_e("ProcessTime");
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }
}

