/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.animation.ITimeValue;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.api.process.Milling;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.library.FilterFluidHandler;
import snownee.cuisine.library.FilterItemHandler;
import snownee.cuisine.library.SingleSlotItemHandler;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.tile.TileBase;

public class TileMill
extends TileBase
implements ITickable {
    private static final int ITEM_SLOT = 0;
    private static final ResourceLocation STATE_MACHINE_JSON = new ResourceLocation("cuisine", "asms/mill.json");
    private final IAnimationStateMachine stateMachine;
    private final TimeValues.VariableValue progressValue = new TimeValues.VariableValue(0.0f);
    private int tick = 0;
    private int power = 0;
    private int cycle = 0;
    private final SingleSlotItemHandler inputBuffer = new SingleSlotItemHandler();
    private final FluidTank fluidInput = new FluidTank(1000);
    private final FluidTank fluidOutput = new FluidTank(1000);

    public TileMill() {
        this.stateMachine = Cuisine.sidedDelegate.loadAnimationStateMachine(STATE_MACHINE_JSON, (ImmutableMap<String, ITimeValue>)ImmutableMap.of((Object)"progress", (Object)this.progressValue));
        this.fluidInput.setTileEntity((TileEntity)this);
        this.fluidOutput.setTileEntity((TileEntity)this);
    }

    public void spillFluids() {
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(this.fluidInput.getFluid(), this.field_145850_b, this.field_174879_c));
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(this.fluidOutput.getFluid(), this.field_145850_b, this.field_174879_c));
    }

    public void onRightClicked(EntityPlayer playerIn) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.power + CuisineConfig.GENERAL.millWorkPeriod / 5 <= CuisineConfig.GENERAL.millWorkPeriod) {
            this.power += CuisineConfig.GENERAL.millWorkPeriod / 5;
            playerIn.func_71020_j(1.0f);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public boolean isWorking() {
        return this.power > 0;
    }

    public void func_73660_a() {
        if (!this.isWorking()) {
            return;
        }
        --this.power;
        if (!this.field_145850_b.field_72995_K) {
            if (++this.tick >= CuisineConfig.GENERAL.millWorkPeriod) {
                this.process();
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                this.tick = 0;
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
        } else {
            if (++this.cycle >= CuisineConfig.GENERAL.millWorkPeriod) {
                this.cycle = 0;
            }
            this.progressValue.setValue((float)this.cycle / (float)CuisineConfig.GENERAL.millWorkPeriod);
        }
    }

    private void process() {
        Milling recipe = Processing.MILLING.findRecipe(this.inputBuffer.getRawContent(), this.fluidInput.getTankProperties()[0].getContents());
        if (recipe != null) {
            if (recipe.getOutputFluid() != null && this.fluidOutput.fill(recipe.getOutputFluid(), false) != recipe.getOutputFluid().amount) {
                return;
            }
            this.inputBuffer.getRawContent().func_190918_g(recipe.getInput().count());
            this.fluidInput.drain(recipe.getInputFluid(), true);
            if (!recipe.getOutput().func_190926_b()) {
                ItemStack finalOutput = recipe.getOutput().func_77946_l();
                for (EnumFacing direction : EnumSet.complementOf(EnumSet.of(EnumFacing.UP))) {
                    IItemHandler targetInv;
                    TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
                    if (target == null || target.getClass() == TileEntityDispenser.class || (targetInv = (IItemHandler)target.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d())) == null) continue;
                    for (int i = 0; i < targetInv.getSlots() && !(finalOutput = targetInv.insertItem(i, finalOutput, false)).func_190926_b(); ++i) {
                    }
                    if (!finalOutput.func_190926_b()) continue;
                    break;
                }
                if (!finalOutput.func_190926_b()) {
                    StacksUtil.spawnItemStack(this.func_145831_w(), this.func_174877_v(), finalOutput, true);
                }
            }
            if (recipe.getOutputFluid() != null) {
                this.fluidOutput.fill(recipe.getOutputFluid().copy(), true);
            }
        }
    }

    public ItemStack tryInsertItem(ItemStack input) {
        if (Milling.isKnownMillingInput(input)) {
            return this.inputBuffer.insertItem(0, input, false);
        }
        return input;
    }

    public ItemStack getItemContent() {
        return this.inputBuffer.getRawContent();
    }

    @Nonnull
    public NBTTagCompound writePacketData(NBTTagCompound data) {
        data.func_74768_a("power", this.power);
        return data;
    }

    public void readPacketData(NBTTagCompound data) {
        this.power = data.func_74762_e("power");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("item", (NBTBase)this.inputBuffer.getRawContent().serializeNBT());
        compound.func_74782_a("fluidInput", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("fluidOutput", (NBTBase)this.fluidOutput.writeToNBT(new NBTTagCompound()));
        compound.func_74768_a("progress", this.tick);
        compound.func_74768_a("power", this.power);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputBuffer.setRawContent(new ItemStack(compound.func_74775_l("item")));
        this.fluidInput.readFromNBT(compound.func_74775_l("fluidInput"));
        this.fluidOutput.readFromNBT(compound.func_74775_l("fluidOutput"));
        this.tick = compound.func_74762_e("progress");
        if (compound.func_150297_b("power", 3)) {
            this.power = compound.func_74762_e("power");
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityAnimation.ANIMATION_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.stateMachine);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new FilterItemHandler(this.inputBuffer, TileMill::isItemValid));
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidOutput);
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new MillFluidHandler(new FilterFluidHandler((IFluidHandler)this.fluidInput, Milling::isKnownMillingInput), (IFluidHandler)this.fluidOutput));
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    private static boolean isItemValid(int slot, ItemStack input) {
        return !input.func_190926_b() && Milling.isKnownMillingInput(input);
    }

    private static final class MillFluidHandler
    implements IFluidHandler {
        private final IFluidHandler input;
        private final IFluidHandler output;

        MillFluidHandler(IFluidHandler input, IFluidHandler output) {
            this.input = input;
            this.output = output;
        }

        public IFluidTankProperties[] getTankProperties() {
            ArrayList<OutputOnlyTankProperties> properties = new ArrayList<OutputOnlyTankProperties>();
            Collections.addAll(properties, this.input.getTankProperties());
            for (IFluidTankProperties outputProperties : this.output.getTankProperties()) {
                properties.add(new OutputOnlyTankProperties(outputProperties));
            }
            return properties.toArray(new IFluidTankProperties[0]);
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.input.fill(resource, doFill);
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack attemptDrainOutput = this.output.drain(resource, doDrain);
            if (attemptDrainOutput == null) {
                return this.input.drain(resource, doDrain);
            }
            return attemptDrainOutput;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack attemptDrainOutput = this.output.drain(maxDrain, doDrain);
            if (attemptDrainOutput == null) {
                return this.input.drain(maxDrain, doDrain);
            }
            return attemptDrainOutput;
        }

        private static final class OutputOnlyTankProperties
        implements IFluidTankProperties {
            private final IFluidTankProperties parent;

            OutputOnlyTankProperties(IFluidTankProperties parent) {
                this.parent = parent;
            }

            @Nullable
            public FluidStack getContents() {
                return this.parent.getContents();
            }

            public int getCapacity() {
                return this.parent.getCapacity();
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrain() {
                return this.parent.canDrain();
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return this.parent.canDrainFluidType(fluidStack);
            }
        }
    }
}

