/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandler;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.api.process.Vessel;
import snownee.cuisine.network.PacketCustomEvent;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.network.NetworkChannel;
import snownee.kiwi.network.PacketMod;
import snownee.kiwi.tile.TileInventoryBase;
import snownee.kiwi.util.InventoryUtil;

public class TileJar
extends TileInventoryBase
implements ITickable {
    private static final int TOTAL_TICK = 1200;
    private int processTime = 0;
    private boolean isWorking = false;
    private boolean invLock = false;
    private final FluidTank tank = new FluidTank(10000){

        protected void onContentsChanged() {
            TileJar.this.resetProcessing();
        }
    };

    public TileJar() {
        super(5);
        this.tank.setTileEntity((TileEntity)this);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    private Object[][] populateInputs() {
        Object[][] inputs = new Object[this.stacks.getSlots()][this.stacks.getSlots() + 1];
        for (int i = 0; i < this.stacks.getSlots(); ++i) {
            inputs[i] = this.populateInputs(i);
        }
        return inputs;
    }

    private Object[] populateInputs(int slot) {
        Object[] inputs = new Object[this.stacks.getSlots() + 1];
        inputs[0] = this.tank.getFluid();
        inputs[1] = this.stacks.getStackInSlot(slot);
        for (int j = 0; j < this.stacks.getSlots(); ++j) {
            if (j == slot) continue;
            inputs[j + (j < slot ? 2 : 1)] = this.stacks.getStackInSlot(j);
        }
        return inputs;
    }

    public void onContentsChanged(int slot) {
        if (!this.invLock) {
            this.resetProcessing();
        }
    }

    public void spillFluids() {
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(this.tank.getFluid(), this.field_145850_b, this.field_174879_c));
    }

    public Vessel findCurrentRecipe() {
        Object[] inputs;
        Vessel recipe = null;
        Object[][] objectArray = this.populateInputs();
        int n = objectArray.length;
        for (int i = 0; i < n && (recipe = Processing.VESSEL.findRecipe(inputs = objectArray[i])) == null; ++i) {
        }
        return recipe;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void forceSetWorkingStatus(boolean working) {
        this.isWorking = working;
        this.processTime = working ? 1200 : 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking && ++this.processTime % 1200 == 0) {
                this.invLock = true;
                for (int i = 0; i < this.stacks.getSlots(); ++i) {
                    Vessel recipe;
                    ItemStack stack = this.stacks.getStackInSlot(i);
                    int count = stack.func_190916_E();
                    if (stack.func_190926_b() || count > this.processTime / 1200 || (recipe = Processing.VESSEL.findRecipe(this.populateInputs(i))) == null) continue;
                    ItemStack output = recipe.getOutput().getItemStack();
                    output.func_190920_e(count);
                    this.stacks.setStackInSlot(i, output);
                    InventoryUtil.consumeItemStack((IItemHandler)this.stacks, (ProcessingInput)recipe.getExtraRequirement(), (int)count, (boolean)false);
                    FluidStack outputFluid = recipe.getOutputFluid();
                    if (outputFluid == null) continue;
                    outputFluid = outputFluid.copy();
                    outputFluid.amount *= this.tank.getFluidAmount() / 100;
                    outputFluid.amount = MathHelper.func_76125_a((int)outputFluid.amount, (int)0, (int)this.tank.getCapacity());
                    this.tank.setFluid(outputFluid);
                }
                this.invLock = false;
                this.resetProcessing();
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
            }
        } else if (this.isWorking && --this.processTime > 0 && this.processTime % 10 == 0) {
            double y = (double)this.field_174879_c.func_177956_o() + 0.12;
            float f = (float)((double)this.processTime / 1200.0 * Math.PI * 2.0);
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)MathHelper.func_76126_a((float)f) * 0.7;
            double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)MathHelper.func_76134_b((float)f) * 0.7;
            this.field_145850_b.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, x, y, z, 0.0, 0.07, 0.0, new int[0]);
        }
    }

    public void resetProcessing() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            Vessel recipe = this.findCurrentRecipe();
            boolean lastWorking = this.isWorking;
            boolean bl = this.isWorking = recipe != null;
            if (!this.isWorking) {
                this.processTime = 0;
            }
            if (this.isWorking || !lastWorking) {
                NetworkChannel.INSTANCE.sendToDimension((PacketMod)new PacketCustomEvent(5, this.field_174879_c, this.isWorking ? 1 : 0), this.func_145831_w().field_73011_w.getDimension());
            }
            this.refresh();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.invLock = true;
        super.func_145839_a(compound);
        this.isWorking = compound.func_74767_n("working");
        this.processTime = compound.func_74762_e("progress");
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.invLock = false;
        this.resetProcessing();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("working", this.isWorking);
        compound.func_74768_a("progress", this.processTime);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return compound;
    }
}

