/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CookingVessel;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.FoodContainer;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.Seasoning;
import snownee.cuisine.api.Spice;
import snownee.cuisine.blocks.BlockDrinkro;
import snownee.cuisine.internal.food.Drink;
import snownee.cuisine.tiles.TileDrinkroBase;
import snownee.kiwi.handler.Battery;
import snownee.kiwi.tile.TileBase;

public class TileDrinkroTank
extends TileBase
implements CookingVessel {
    private boolean powered = false;
    protected boolean working = false;
    public Drink.Builder builder;
    public final ItemStackHandler inventory;
    @Nullable
    public final Battery battery;

    public TileDrinkroTank() {
        this.battery = CuisineConfig.GENERAL.drinkroUsesFE > 0 ? new Battery(CuisineConfig.GENERAL.drinkroUsesFE * 50, CuisineConfig.GENERAL.drinkroUsesFE, 0) : null;
        this.builder = Drink.Builder.create();
        this.inventory = new ItemStackHandler(4){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (Drink.Builder.isFeatureItem(stack)) {
                    return true;
                }
                Spice spice = CulinaryHub.API_INSTANCE.findSpice(stack);
                return spice != null && TileDrinkroTank.this.builder != null && TileDrinkroTank.this.builder.canAddIntoThis(null, new Seasoning(spice), (CookingVessel)TileDrinkroTank.this);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (TileDrinkroTank.this.isWorking() || !this.isItemValid(slot, stack)) {
                    return stack;
                }
                if (Drink.Builder.isFeatureItem(stack)) {
                    for (ItemStack stack2 : this.stacks) {
                        if (!Drink.Builder.isFeatureItem(stack2)) continue;
                        return stack;
                    }
                }
                return super.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (TileDrinkroTank.this.isWorking()) {
                    return ItemStack.field_190927_a;
                }
                return super.extractItem(slot, amount, simulate);
            }

            protected void onContentsChanged(int slot) {
                TileDrinkroTank.this.refresh();
            }
        };
    }

    public void neighborChanged(IBlockState state) {
        boolean poweredIn = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (!poweredIn) {
            poweredIn = this.field_145850_b.func_175640_z(this.field_174879_c.func_177977_b());
        }
        if (poweredIn && !this.powered && !this.isWorking()) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
            if (this.battery == null || this.battery.getEnergyStored() >= CuisineConfig.GENERAL.drinkroUsesFE) {
                this.working = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177226_a((IProperty)BlockDrinkro.WORKING, (Comparable)Boolean.TRUE), 11);
                this.field_145850_b.func_180501_a(this.field_174879_c.func_177977_b(), this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177226_a((IProperty)BlockDrinkro.WORKING, (Comparable)Boolean.TRUE), 11);
                this.field_145850_b.func_175684_a(this.field_174879_c, state.func_177230_c(), 100);
            }
        }
        this.powered = poweredIn;
    }

    protected TileDrinkroBase getBase() {
        TileEntity tile;
        if (this.func_145830_o() && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) instanceof TileDrinkroBase) {
            return (TileDrinkroBase)tile;
        }
        return null;
    }

    public void stopProcess() {
        ItemStack input;
        int i;
        this.working = false;
        if (this.battery != null && this.battery.getEnergyStored() < CuisineConfig.GENERAL.drinkroUsesFE) {
            return;
        }
        TileDrinkroBase tileBase = this.getBase();
        if (tileBase == null) {
            return;
        }
        ItemStackHandler inputs = this.inventory;
        int slotCount = 0;
        for (int i2 = 0; i2 < inputs.getSlots(); ++i2) {
            if (inputs.getStackInSlot(i2).func_190926_b()) continue;
            ++slotCount;
        }
        if (this.builder.getIngredients().isEmpty() && this.builder.getIngredients().size() + this.builder.getIngredients().size() + slotCount < 2) {
            return;
        }
        Drink.DrinkType type = Drink.DrinkType.NORMAL;
        int featureSlot = -1;
        for (i = 0; i < inputs.getSlots(); ++i) {
            input = inputs.getStackInSlot(i);
            if (input.func_190926_b() || (type = Drink.Builder.findDrinkType(input)) == Drink.DrinkType.NORMAL) continue;
            featureSlot = i;
            break;
        }
        if (!type.getContainerPre().matches(tileBase.inventory.getStackInSlot(0))) {
            return;
        }
        this.builder.drinkType = type;
        for (i = 0; i < inputs.getSlots(); ++i) {
            Spice spice;
            if (i == featureSlot || (input = inputs.getStackInSlot(i)).func_190926_b() || (spice = CulinaryHub.API_INSTANCE.findSpice(input)) == null) continue;
            this.builder.addSeasoning(null, new Seasoning(spice), this);
        }
        Optional<Drink> result = this.builder.build(this, null);
        if (!result.isPresent()) {
            return;
        }
        Drink drink = result.get();
        ItemStack itemDrink = new ItemStack((Item)CuisineRegistry.DRINK);
        FoodContainer container = (FoodContainer)itemDrink.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container == null) {
            throw new NullPointerException("Null FoodContainer");
        }
        container.set(drink);
        tileBase.inventory.setStackInSlot(0, itemDrink);
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 0, this.builder.getColor());
        if (this.battery != null) {
            this.battery.setEnergy(this.battery.getEnergyStored() - CuisineConfig.GENERAL.drinkroUsesFE);
        }
        for (int i3 = 0; i3 < inputs.getSlots(); ++i3) {
            ItemStack stack = inputs.getStackInSlot(i3);
            if (stack.func_190926_b()) continue;
            stack.func_190918_g(1);
        }
        this.builder = Drink.Builder.create();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY && this.battery != null || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new DrinkroFluidWrapper(this));
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityEnergy.ENERGY && this.battery != null) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.battery);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.powered = data.func_74767_n("powered");
        this.inventory.deserializeNBT(data.func_74775_l("inventory"));
        if (this.battery != null) {
            this.battery.readFromNBT(data);
        }
        this.working = data.func_74767_n("working");
        this.builder = Drink.Builder.fromNBT(data.func_74775_l("builder"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74757_a("powered", this.powered);
        data.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (this.battery != null) {
            this.battery.writeToNBT(data);
        }
        data.func_74757_a("working", this.working);
        data.func_74782_a("builder", (NBTBase)Drink.Builder.toNBT(this.builder));
        return data;
    }

    protected void readPacketData(NBTTagCompound data) {
        this.inventory.deserializeNBT(data.func_74775_l("inventory"));
        if (this.battery != null) {
            this.battery.readFromNBT(data);
        }
        this.builder = Drink.Builder.fromNBT(data.func_74775_l("builder"));
        this.working = data.func_74767_n("working");
    }

    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        data.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (this.battery != null) {
            this.battery.writeToNBT(data);
        }
        data.func_74782_a("builder", (NBTBase)Drink.Builder.toNBT(this.builder));
        data.func_74757_a("working", this.working);
        return data;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() != CuisineRegistry.DRINKRO || newState.func_177230_c() != CuisineRegistry.DRINKRO) {
            return true;
        }
        return oldState.func_177229_b((IProperty)BlockDrinkro.BASE) != newState.func_177229_b((IProperty)BlockDrinkro.BASE);
    }

    public boolean isWorking() {
        return this.working;
    }

    protected void refresh() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, state, state, 11);
        }
    }

    @Override
    public Optional<ItemStack> serve() {
        ItemStack stack;
        TileDrinkroBase base;
        if (!this.isWorking() && (base = this.getBase()) != null && (stack = base.inventory.getStackInSlot(0)).hasCapability(CulinaryCapabilities.FOOD_CONTAINER, null)) {
            base.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    protected static class DrinkroFluidWrapper
    implements IFluidHandler {
        private final TileDrinkroTank tile;

        public DrinkroFluidWrapper(TileDrinkroTank tile) {
            this.tile = tile;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[0];
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null || resource.amount < 250 || this.tile.isWorking()) {
                return 0;
            }
            Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(resource);
            if (ingredient == null || ingredient.getForm() != Form.JUICE || !this.tile.builder.canAddIntoThis(null, ingredient, (CookingVessel)this.tile)) {
                return 0;
            }
            int i = this.tile.builder.getMaxIngredientLimit() - this.tile.builder.getIngredients().size();
            int amount = resource.amount;
            int amountAdded = 0;
            while (amount >= 250 && i-- > 0 && (!doFill || this.tile.builder.addIngredient(null, ingredient.copy(), this.tile))) {
                amount -= 250;
                amountAdded += 250;
            }
            return amountAdded;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

