/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.blocks.BlockDrinkro;
import snownee.cuisine.internal.food.Drink;
import snownee.cuisine.tiles.TileDrinkroTank;
import snownee.kiwi.tile.TileBase;

public class TileDrinkroBase
extends TileBase {
    private boolean powered = false;
    public ItemStackHandler inventory = new ItemStackHandler(){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return Drink.Builder.isContainerItem(stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileDrinkroBase.this.refresh();
        }
    };

    protected TileDrinkroTank getTank() {
        TileEntity tile;
        if (this.func_145830_o() && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) instanceof TileDrinkroTank) {
            return (TileDrinkroTank)tile;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && CuisineConfig.GENERAL.drinkroUsesFE > 0) {
            TileDrinkroTank tile = this.getTank();
            return tile == null ? false : tile.hasCapability(capability, facing);
        }
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getTank() != null || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            TileDrinkroTank tile = this.getTank();
            return tile == null ? null : (T)tile.getCapability(capability, facing);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityEnergy.ENERGY && CuisineConfig.GENERAL.drinkroUsesFE > 0) {
            TileDrinkroTank tile = this.getTank();
            return tile == null ? null : (T)tile.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.powered = data.func_74767_n("powered");
        this.inventory.deserializeNBT(data.func_74775_l("inventory"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74757_a("powered", this.powered);
        data.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return data;
    }

    protected void readPacketData(NBTTagCompound data) {
        this.inventory.deserializeNBT(data.func_74775_l("inventory"));
    }

    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        data.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return data;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() != CuisineRegistry.DRINKRO || newState.func_177230_c() != CuisineRegistry.DRINKRO) {
            return true;
        }
        return oldState.func_177229_b((IProperty)BlockDrinkro.BASE) != newState.func_177229_b((IProperty)BlockDrinkro.BASE);
    }

    protected void refresh() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, state, state, 11);
        }
    }
}

