/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CulinaryCapabilities;
import snownee.cuisine.api.FoodContainer;
import snownee.cuisine.api.events.ConsumeCompositeFoodEvent;
import snownee.cuisine.internal.food.Dish;
import snownee.kiwi.tile.TileBase;

public class TileDish
extends TileBase {
    private ItemStack dishContainer = ItemStack.field_190927_a;

    public void readDish(ItemStack dish) {
        FoodContainer container = (FoodContainer)dish.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container != null) {
            this.dishContainer = dish;
            if (!dish.func_190926_b()) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
        }
    }

    public ItemStack getItem() {
        return this.dishContainer.func_190926_b() ? new ItemStack((Block)CuisineRegistry.PLACED_DISH) : this.dishContainer.func_77946_l();
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound data;
        Dish dish;
        super.func_145839_a(compound);
        if (compound.func_150297_b("DishContainer", 10)) {
            this.dishContainer = new ItemStack(compound.func_74775_l("DishContainer"));
        } else if (compound.func_150297_b("dish", 10) && (dish = Dish.deserialize(data = compound.func_74775_l("dish"))) != null) {
            this.dishContainer = dish.makeItemStack();
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("DishContainer", (NBTBase)this.dishContainer.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Nonnull
    public String getDishModelType() {
        CompositeFood dish;
        FoodContainer container = (FoodContainer)this.dishContainer.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container != null && (dish = container.get()) != null) {
            return dish.getOrComputeModelType();
        }
        return "empty";
    }

    public boolean onEatenBy(EntityPlayer player) {
        ConsumeCompositeFoodEvent.Pre pre;
        CompositeFood dish;
        if (this.dishContainer.func_190926_b()) {
            return false;
        }
        FoodContainer container = (FoodContainer)this.dishContainer.getCapability(CulinaryCapabilities.FOOD_CONTAINER, null);
        if (container != null && (dish = container.get()) != null && !MinecraftForge.EVENT_BUS.post((Event)(pre = new ConsumeCompositeFoodEvent.Pre(dish, player, this.field_174879_c))) && pre.getResult() != Event.Result.DENY && !(player instanceof FakePlayer) && this.func_145830_o() && player.func_71043_e(dish.alwaysEdible())) {
            dish.setServes(dish.getServes() - 1);
            this.func_145831_w().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
            dish.onEaten(this.dishContainer, this.func_145831_w(), player);
            ConsumeCompositeFoodEvent.Post post = new ConsumeCompositeFoodEvent.Post(dish, player, this.field_174879_c);
            MinecraftForge.EVENT_BUS.post((Event)post);
            if (dish.getServes() <= 0) {
                this.field_145850_b.func_175713_t(this.field_174879_c);
            }
            return true;
        }
        return false;
    }

    protected void readPacketData(NBTTagCompound data) {
        this.dishContainer = new ItemStack(data.func_74775_l("DishContainer"));
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @Nonnull
    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        data.func_74782_a("DishContainer", (NBTBase)this.dishContainer.serializeNBT());
        return data;
    }
}

