/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.CulinarySkillPoint;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.process.Chopping;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.api.util.SkillUtil;
import snownee.cuisine.client.particle.ParticleQuad;
import snownee.cuisine.internal.CuisinePersistenceCenter;
import snownee.cuisine.items.ItemIngredient;
import snownee.kiwi.tile.TileInventoryBase;
import snownee.kiwi.util.NBTHelper;
import snownee.kiwi.util.OreUtil;

public class TileChoppingBoard
extends TileInventoryBase {
    private EnumFacing facing = EnumFacing.NORTH;
    private boolean isAxe = false;
    private int chopped = 0;
    public long tickLastChop;
    public static final ItemStack DEFAULT_COVER = new ItemStack(Blocks.field_150364_r);
    private ItemStack cover = ItemStack.field_190927_a;

    public TileChoppingBoard() {
        super(1, 1);
    }

    public void resetProcess() {
        this.isAxe = false;
        this.chopped = 0;
    }

    public ItemStack insertItem(EntityPlayer player, ItemStack stack) {
        Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(stack);
        if (ingredient != null && ingredient.getForm() != Form.JUICE && !ingredient.getMaterial().getValidForms().isEmpty() && (ingredient.getMaterial().getValidForms().size() > 1 || !ingredient.getMaterial().getValidForms().contains((Object)Form.JUICE)) && this.stacks.getStackInSlot(0).func_190926_b() && stack.func_190916_E() >= 2 && SkillUtil.hasPlayerLearnedSkill(player, CulinaryHub.CommonSkills.DOUBLE_CHOPPING)) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(2);
            this.stacks.setStackInSlot(0, copy);
            stack.func_190918_g(2);
            return stack;
        }
        ItemStack ret = this.stacks.insertItem(0, stack, false);
        ItemStack con = this.stacks.getStackInSlot(0);
        this.isAxe = CuisineConfig.GENERAL.axeChopping && !con.func_190926_b() && !OreUtil.doesItemHaveOreName((ItemStack)stack, (String)"itemFoodCutter") && con.func_77973_b() != CuisineRegistry.INGREDIENT && !CulinaryHub.API_INSTANCE.isKnownIngredient(con) && Processing.CHOPPING.findRecipe(con) != null;
        return ret;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        if (OreUtil.doesItemHaveOreName((ItemStack)stack, (String)"itemFoodCutter")) {
            return true;
        }
        if (CuisineConfig.GENERAL.axeChopping && Processing.CHOPPING.findRecipe(stack) != null) {
            return true;
        }
        Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(stack);
        return ingredient != null && ingredient.getForm() != Form.JUICE && !ingredient.getMaterial().getValidForms().isEmpty() && (ingredient.getMaterial().getValidForms().size() > 1 || !ingredient.getMaterial().getValidForms().contains((Object)Form.JUICE));
    }

    public boolean hasKitchenKnife() {
        return OreUtil.doesItemHaveOreName((ItemStack)this.stacks.getStackInSlot(0), (String)"itemFoodCutter");
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("facing", 3)) {
            this.facing = EnumFacing.func_176731_b((int)compound.func_74762_e("facing"));
        }
        if (compound.func_150297_b("axe", 1)) {
            this.isAxe = compound.func_74767_n("axe");
        }
        if (compound.func_150297_b("chopped", 3)) {
            this.chopped = compound.func_74762_e("chopped");
        }
        ItemStack itemStack = this.cover = compound.func_150297_b("cover", 10) ? new ItemStack(compound.func_74775_l("cover")) : DEFAULT_COVER;
        if (this.cover.func_190926_b()) {
            this.setCover(DEFAULT_COVER);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("facing", this.facing.func_176736_b());
        compound.func_74757_a("axe", this.isAxe);
        compound.func_74768_a("chopped", this.chopped);
        if (this.cover.func_190926_b()) {
            this.setCover(DEFAULT_COVER);
        }
        compound.func_74782_a("cover", (NBTBase)this.cover.serializeNBT());
        return compound;
    }

    @Nonnull
    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        data.func_74768_a("facing", this.facing.func_176736_b());
        data.func_74757_a("axe", this.isAxe);
        if (this.cover.func_190926_b()) {
            this.setCover(DEFAULT_COVER);
        }
        data.func_74782_a("cover", (NBTBase)this.cover.serializeNBT());
        return super.writePacketData(data);
    }

    protected void readPacketData(NBTTagCompound data) {
        super.readPacketData(data);
        this.facing = EnumFacing.func_176731_b((int)data.func_74762_e("facing"));
        this.isAxe = data.func_74767_n("axe");
        this.cover = new ItemStack(data.func_74775_l("cover"));
        if (this.cover.func_190926_b()) {
            this.setCover(DEFAULT_COVER);
        }
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public void setCover(ItemStack cover) {
        this.cover = cover;
    }

    public ItemStack getCover() {
        return this.cover;
    }

    public ItemStack getSelfItem() {
        return CuisineRegistry.CHOPPING_BOARD.getItemStack(this.cover);
    }

    public void process(EntityPlayer playerIn, ItemStack tool, ProcessionType type, @Nullable Integer harvestlevel) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 0.3f, 0.5f);
        ItemStack stack = this.stacks.getStackInSlot(0);
        if (this.field_145850_b.field_72995_K && !stack.func_190926_b()) {
            this.updateTick(stack);
            return;
        }
        if (ProcessionType.AXE != type) {
            int i;
            Ingredient processingIngredient = TileChoppingBoard.tryConvert(stack);
            if (processingIngredient == null) {
                return;
            }
            if (playerIn instanceof EntityPlayerMP) {
                AxisAlignedBB axisalignedbb;
                List list;
                tool.func_96631_a(1, this.field_145850_b.field_73012_v, (EntityPlayerMP)playerIn);
                if (SkillUtil.hasPlayerLearnedSkill(playerIn, CulinaryHub.CommonSkills.SKILLED_CHOPPING)) {
                    if (processingIngredient.getMaterial() == CulinaryHub.CommonMaterials.PUFFERFISH) {
                        processingIngredient.removeEffect(CulinaryHub.CommonEffects.PUFFERFISH_POISON);
                    }
                } else if (processingIngredient.getMaterial() == CulinaryHub.CommonMaterials.ONION && !(list = this.field_145850_b.func_72872_a(EntityLivingBase.class, axisalignedbb = new AxisAlignedBB(this.field_174879_c).func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
                    for (EntityLivingBase entitylivingbase : list) {
                        double d1;
                        int i2;
                        double d0;
                        if (!entitylivingbase.func_184603_cC() || !((d0 = entitylivingbase.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5)) < 16.0) || (i2 = (int)((d1 = 1.0 - Math.sqrt(d0) / 4.0) * 400.0)) <= 20) continue;
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76440_q, i2, 0, true, false));
                        entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76431_k, i2, 0, true, false));
                        if (!(entitylivingbase instanceof EntityPlayerMP)) continue;
                        SkillUtil.increasePoint((EntityPlayer)((EntityPlayerMP)entitylivingbase), CulinarySkillPoint.EXPERTISE, 2);
                    }
                }
            }
            int[] actions = ItemIngredient.getActions(stack);
            int n = i = type == ProcessionType.KNIFE_VERTICAL ? 1 : 0;
            if (actions[i] < type.getMaxProcessLimit()) {
                int n2 = i;
                actions[n2] = actions[n2] + 1;
            }
            if (playerIn instanceof EntityPlayerMP && actions[i] < 10 && this.func_145831_w().field_73012_v.nextInt(5) == 0) {
                SkillUtil.increasePoint(playerIn, CulinarySkillPoint.PROFICIENCY, 1);
            }
            this.stacks.setStackInSlot(0, TileChoppingBoard.craftMaterial(stack, processingIngredient, actions, this.field_145850_b.field_73012_v));
        } else if (this.isAxe) {
            Chopping recipe;
            harvestlevel = harvestlevel == null ? 1 : harvestlevel + 1;
            tool.func_77972_a(1, (EntityLivingBase)playerIn);
            this.chopped += harvestlevel.intValue();
            if ((tool.func_190926_b() || this.chopped >= type.getMaxProcessLimit()) && (recipe = Processing.CHOPPING.findRecipe(this.stacks.getStackInSlot(0))) != null) {
                recipe.consume((IItemHandler)this.stacks);
                if (!this.field_145850_b.field_72995_K) {
                    ItemStack output = recipe.getOutput().func_77946_l();
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)output.func_77979_a(output.func_190916_E() / 2));
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)output);
                }
                this.resetProcess();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateTick(ItemStack stack) {
        if (stack.func_77973_b() == CuisineRegistry.KITCHEN_KNIFE) {
            return;
        }
        this.tickLastChop = Minecraft.func_71386_F();
        Minecraft mc = Minecraft.func_71410_x();
        if (stack.func_77973_b() == CuisineRegistry.INGREDIENT) {
            Ingredient ingredient = CulinaryHub.API_INSTANCE.findIngredient(stack);
            if (ingredient == null) {
                return;
            }
            int color = ingredient.getMaterial().getColorCode(ingredient.getDoneness());
            for (int i = 0; i < 4; ++i) {
                mc.field_71452_i.func_78873_a((Particle)new ParticleQuad(this.field_145850_b, this.field_174879_c, color));
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                this.field_145850_b.func_175682_a(EnumParticleTypes.ITEM_CRACK, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.3, (double)this.field_174879_c.func_177952_p() + 0.5, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.2, 0.1, (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.2, new int[]{Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j()});
            }
        }
    }

    private static ItemStack craftMaterial(ItemStack raw, Ingredient ingredient, int[] actions, Random rand) {
        Form form = Form.byActions(actions[0], actions[1]);
        if (ingredient.getMaterial().isValidForm(form)) {
            ingredient.setForm(form);
        } else if (raw.func_77973_b() != CuisineRegistry.INGREDIENT) {
            return NBTHelper.of((ItemStack)raw).setIntArray("actions", actions).getItem();
        }
        ItemStack itemIngredient = ItemIngredient.make(ingredient);
        itemIngredient.func_190920_e(raw.func_190916_E());
        return NBTHelper.of((ItemStack)itemIngredient).setIntArray("actions", actions).getItem();
    }

    private static Ingredient tryConvert(ItemStack stack) {
        if (stack.func_77973_b() == CuisineRegistry.INGREDIENT) {
            NBTTagCompound data = stack.func_77978_p();
            if (data == null) {
                return null;
            }
            return CuisinePersistenceCenter.deserializeIngredient(data);
        }
        return CulinaryHub.API_INSTANCE.findIngredient(stack);
    }

    public void onContentsChanged(int slot) {
        this.refresh();
    }

    public static enum ProcessionType {
        KNIFE_HORIZONTAL,
        KNIFE_VERTICAL,
        AXE;


        public int getMaxProcessLimit() {
            return this != AXE ? 10 : 8;
        }
    }
}

