/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.api.process.BasinInteracting;
import snownee.cuisine.api.process.Boiling;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.tiles.TileBasin;
import snownee.cuisine.util.StacksUtil;
import snownee.kiwi.util.NBTHelper;

public class TileBasinHeatable
extends TileBasin
implements ITickable {
    public static final Map<Block, Integer> BLOCK_HEAT_SOURCES = new HashMap<Block, Integer>();
    public static final Map<IBlockState, Integer> STATE_HEAT_SOURCES = new HashMap<IBlockState, Integer>();
    public static final Map<Block, ItemStack> BLOCK_TO_ITEM = new HashMap<Block, ItemStack>();
    public static final Map<IBlockState, ItemStack> STATE_TO_ITEM = new HashMap<IBlockState, ItemStack>();
    public static int HEATING_TICK = 1800;
    protected int tick = 0;
    protected int heat = 0;
    protected boolean invLock = false;
    protected Boiling boilingRecipe;

    public static void registerHeatSource(int heatValue, IBlockState state) {
        STATE_HEAT_SOURCES.put(state, heatValue);
    }

    public static void registerHeatSource(int heatValue, IBlockState state, ItemStack stack) {
        STATE_HEAT_SOURCES.put(state, heatValue);
        STATE_TO_ITEM.put(state, stack);
    }

    public static void registerHeatSource(int heatValue, Block block) {
        BLOCK_HEAT_SOURCES.put(block, heatValue);
    }

    public static void registerHeatSource(int heatValue, Block block, ItemStack stack) {
        BLOCK_HEAT_SOURCES.put(block, heatValue);
        BLOCK_TO_ITEM.put(block, stack);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.boilingRecipe == null) {
            return;
        }
        if (!(this.heat != 0 || this.field_145850_b.field_73011_w.func_177495_o() || this.field_145850_b.field_73011_w.func_191066_m() && this.field_145850_b.func_72935_r() && !this.field_145850_b.func_72896_J() && this.field_145850_b.func_175678_i(this.field_174879_c))) {
            return;
        }
        this.tick += this.getHeatingBoost(this.heat);
        if (this.tick >= HEATING_TICK) {
            this.tick = 0;
            if (this.tank.getFluid() != null && this.boilingRecipe.matches(this.stacks.getStackInSlot(0), this.tank.getFluid(), this.heat)) {
                this.invLock = true;
                BasinInteracting.Output output = this.boilingRecipe.getOutputAndConsumeInput(this.stacks.getStackInSlot(0), this.tank.getFluid(), this.heat, this.field_145850_b.field_73012_v);
                if (output.fluid != null && output.fluid.amount <= 0) {
                    output.fluid = null;
                }
                this.tank.setFluid(output.fluid);
                StacksUtil.spawnItemStack(this.field_145850_b, this.field_174879_c, output.item, true);
                this.invLock = false;
                this.onContentsChanged(0);
                this.refresh();
            }
        }
    }

    public int getCurrentHeat() {
        return TileBasinHeatable.getHeatValueFromState(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()));
    }

    public int getCurrentHeatingTick() {
        return this.tick;
    }

    public Boiling getCurrentHeatingRecipe() {
        return this.boilingRecipe;
    }

    public int getHeatingBoost(int heat) {
        return 3 + heat * 2;
    }

    public boolean canWork() {
        if (this.tank.getFluid() == null) {
            return false;
        }
        return this.heat > 0 || CuisineConfig.GENERAL.basinHeatingInDaylight;
    }

    @Override
    public void onContentsChanged(int slot) {
        if (!this.invLock) {
            super.onContentsChanged(slot);
            if (!this.field_145850_b.field_72995_K) {
                if (!this.canWork()) {
                    this.boilingRecipe = null;
                    return;
                }
                if (this.boilingRecipe != null && this.boilingRecipe.matches(this.stacks.getStackInSlot(0), this.tank.getFluid(), this.heat)) {
                    return;
                }
                this.boilingRecipe = Processing.BOILING.findRecipe(this.stacks.getStackInSlot(0), this.tank.getFluid(), this.heat);
            }
            this.tick = 0;
        }
    }

    public static int getHeatValueFromState(IBlockState state) {
        Integer heat = STATE_HEAT_SOURCES.get(state);
        if (heat != null) {
            return heat;
        }
        heat = BLOCK_HEAT_SOURCES.get(state.func_177230_c());
        return heat != null ? heat : 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.invLock = true;
        super.func_145839_a(compound);
        NBTHelper tag = NBTHelper.of((NBTTagCompound)compound);
        this.heat = tag.getInt("heat");
        this.tick = tag.getInt("tick");
        if (tag.hasTag("recipe", 8)) {
            this.boilingRecipe = Processing.BOILING.findRecipe(new ResourceLocation(tag.getString("recipe", "")));
        }
        this.invLock = false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("heat", this.heat);
        compound.func_74768_a("tick", this.tick);
        if (this.boilingRecipe != null) {
            compound.func_74778_a("recipe", this.boilingRecipe.getIdentifier().toString());
        }
        return super.func_189515_b(compound);
    }

    public void onLoad() {
        super.onLoad();
        this.onContentsChanged(0);
    }

    public void updateHeat() {
        this.heat = this.getCurrentHeat();
        if (this.canWork()) {
            this.onContentsChanged(0);
        }
    }

    static {
        TileBasinHeatable.registerHeatSource(1, Blocks.field_150428_aP, new ItemStack(Blocks.field_150428_aP));
        TileBasinHeatable.registerHeatSource(1, Blocks.field_150478_aa, new ItemStack(Blocks.field_150478_aa));
        TileBasinHeatable.registerHeatSource(2, Blocks.field_150470_am, new ItemStack(Blocks.field_150460_al));
        TileBasinHeatable.registerHeatSource(3, (Block)Blocks.field_150480_ab, new ItemStack(Items.field_151033_d));
        TileBasinHeatable.registerHeatSource(3, Blocks.field_189877_df, new ItemStack(Blocks.field_189877_df));
        TileBasinHeatable.registerHeatSource(4, (Block)Blocks.field_150353_l, new ItemStack(Items.field_151129_at));
        TileBasinHeatable.registerHeatSource(4, (Block)Blocks.field_150356_k);
    }
}

