/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.api.process.BasinInteracting;
import snownee.cuisine.api.process.CuisineProcessingRecipeManager;
import snownee.cuisine.api.process.Processing;
import snownee.kiwi.tile.TileInventoryBase;

public class TileBasin
extends TileInventoryBase {
    public FluidTank tank = new FluidTank(8000){

        protected void onContentsChanged() {
            TileBasin.this.onContentsChanged(0);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            if (fluid == null || !this.canFill() || fluid.getFluid().isGaseous(fluid) || fluid.getFluid().isLighterThanAir()) {
                return false;
            }
            return ((Object)((Object)TileBasin.this)).getClass() != TileBasin.class || fluid.getFluid().getTemperature(fluid) < 500;
        }
    };
    public int tickCheckThrowing = 0;
    private float renderingAmount = 0.0f;
    boolean squeezingFailed = false;

    public TileBasin() {
        super(1);
        this.tank.setTileEntity((TileEntity)this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void spillFluids() {
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(this.tank.getFluid(), this.field_145850_b, this.field_174879_c));
    }

    @SideOnly(value=Side.CLIENT)
    public FluidStack getFluidForRendering(float partialTicks) {
        FluidStack actual = this.tank.getFluid();
        if (actual == null) {
            this.renderingAmount = 0.0f;
            return null;
        }
        float delta = (float)actual.amount - this.renderingAmount;
        this.renderingAmount = Math.abs(delta) < 40.0f ? (float)actual.amount : (float)((double)this.renderingAmount + (double)(delta * partialTicks) * 0.1);
        return new FluidStack(actual, (int)this.renderingAmount);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        if (this.tank.getFluid() != null) {
            this.renderingAmount = this.tank.getFluid().amount;
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        compound.func_74757_a("squeezingFailed", this.squeezingFailed);
        return compound;
    }

    protected void readPacketData(NBTTagCompound data) {
        super.readPacketData(data);
        this.tank.readFromNBT(data.func_74775_l("tank"));
        if (data.func_150297_b("squeezingFailed", 1)) {
            this.squeezingFailed = data.func_74767_n("squeezingFailed");
        }
    }

    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        super.writePacketData(data);
        data.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return this.func_189515_b(data);
    }

    public void process(CuisineProcessingRecipeManager<BasinInteracting> recipeManager, ItemStack input, boolean simulated) {
        if (this.squeezingFailed && recipeManager == Processing.SQUEEZING) {
            return;
        }
        if (input.func_190926_b()) {
            this.squeezingFailed = true;
            return;
        }
        FluidStack fluid = this.tank.getFluid();
        BasinInteracting recipe = recipeManager.findRecipe(input, fluid);
        if (recipe != null) {
            BasinInteracting.Output output = recipe.getOutput(input, fluid, this.field_145850_b.field_73012_v);
            if (output.fluid != null) {
                if (output.fluid.amount > this.tank.getCapacity()) {
                    this.squeezingFailed = true;
                    return;
                }
                if (output.fluid.amount <= 0) {
                    output.fluid = null;
                }
                if (!simulated) {
                    this.tank.setFluid(output.fluid);
                }
            }
            if (!simulated) {
                if (!output.item.func_190926_b()) {
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)output.item);
                }
                recipe.consumeInput(input, fluid, this.field_145850_b.field_73012_v);
            }
            this.refresh();
        } else {
            this.squeezingFailed = true;
        }
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return BasinInteracting.isKnownInput(Processing.SQUEEZING, stack);
    }

    public void onContentsChanged(int slot) {
        this.squeezingFailed = false;
        this.refresh();
    }

    public FluidStack getCurrentFluidContent() {
        FluidStack content = this.tank.getFluid();
        if (content == null) {
            return null;
        }
        return content.copy();
    }
}

