/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Material;
import snownee.cuisine.tiles.FuelHeatHandler;
import snownee.cuisine.tiles.TileFirePit;
import snownee.kiwi.util.NBTHelper;

public class TileBarbecueRack
extends TileFirePit {
    public final ItemStackHandler stacks;
    public int[] burnTime = new int[3];
    public boolean[] completed = new boolean[3];
    private boolean isEmpty;

    public TileBarbecueRack() {
        this.stacks = new ItemStackHandler(4){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                if (slot == 3) {
                    return TileBarbecueRack.this.heatHandler.addFuel(stack);
                }
                return super.insertItem(slot, stack, simulate);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot < 3) {
                    return stack.func_77973_b() == CuisineRegistry.INGREDIENT || FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77973_b() instanceof ItemFood;
                }
                return FuelHeatHandler.isFuel(stack, true);
            }

            protected void onContentsChanged(int slot) {
                for (int i = 0; i < 3; ++i) {
                    ItemStack stack = this.getStackInSlot(i);
                    if (!stack.func_190926_b()) continue;
                    TileBarbecueRack.this.burnTime[i] = 0;
                    TileBarbecueRack.this.completed[i] = false;
                }
                TileBarbecueRack.this.refreshEmpty();
                TileBarbecueRack.this.refresh();
            }
        };
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.heatHandler.getHeatPower() > 0.0f) {
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = this.stacks.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() == CuisineRegistry.INGREDIENT) {
                    NBTHelper helper = NBTHelper.of((ItemStack)stack);
                    Material material = CulinaryHub.API_INSTANCE.findMaterial(helper.getString("material"));
                    double progress = material == null ? 1.0 : (material.getBoilHeat() <= this.heatHandler.getHeat() ? Math.pow(material.getBoilHeat() - this.heatHandler.getHeat(), 2.0) / Math.pow(material.getBoilHeat(), 2.0) + 1.0 : 1.0 - Math.pow(material.getBoilHeat() - this.heatHandler.getHeat(), 2.0) / Math.pow(material.getBoilHeat(), 2.0));
                    progress += (double)MathHelper.func_76128_c((double)MathHelper.func_151237_a((double)progress, (double)0.0, (double)(material == null ? 400.0 : (double)material.getBoilTime())));
                    int n = i;
                    this.burnTime[n] = this.burnTime[n] + (int)progress;
                    if (this.burnTime[i] < 6) continue;
                    this.burnTime[i] = 0;
                    int doneness = helper.getInt("doneness");
                    helper.setInt("doneness", doneness + (int)progress);
                    continue;
                }
                int n = i;
                this.burnTime[n] = this.burnTime[n] + this.heatHandler.getLevel();
                if (this.burnTime[i] < 800) continue;
                this.burnTime[i] = 0;
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
                if (result.func_190926_b()) continue;
                this.stacks.setStackInSlot(i, result.func_77946_l());
                if (this.stacks.isItemValid(0, result)) continue;
                this.completed[i] = true;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        int[] arr;
        int[] burnTime;
        super.func_145839_a(compound);
        NBTHelper helper = NBTHelper.of((NBTTagCompound)compound);
        this.stacks.deserializeNBT(helper.getTag("Items", true));
        this.refreshEmpty();
        if (helper.hasTag("burnTime", 11) && (burnTime = helper.getIntArray("burnTime")).length == 3) {
            this.burnTime = burnTime;
        }
        if (helper.hasTag("completed", 11) && (arr = helper.getIntArray("completed")).length == 3) {
            for (int i = 0; i < arr.length; ++i) {
                this.completed[i] = arr[i] > 0;
            }
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = super.func_189515_b(compound);
        tag.func_74783_a("burnTime", this.burnTime);
        int[] arr = new int[3];
        for (int i = 0; i < this.completed.length; ++i) {
            arr[i] = this.completed[i] ? 1 : 0;
        }
        tag.func_74783_a("completed", arr);
        tag.func_74782_a("Items", (NBTBase)this.stacks.serializeNBT());
        return tag;
    }

    @Override
    @Nonnull
    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        return this.func_189515_b(data);
    }

    @Override
    protected void readPacketData(NBTTagCompound data) {
        this.func_145839_a(data);
        this.refreshEmpty();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.stacks);
        }
        return (T)super.getCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return Block.field_185505_j.func_186670_a(this.field_174879_c);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private void refreshEmpty() {
        this.isEmpty = true;
        for (int i = 0; i < 3; ++i) {
            if (this.stacks.getStackInSlot(i).func_190926_b()) continue;
            this.isEmpty = false;
            break;
        }
    }
}

