/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.internal.CuisinePersistenceCenter;
import snownee.cuisine.tiles.TileWok;
import snownee.kiwi.network.PacketMod;

public class PacketIncrementalWokUpdate
implements PacketMod {
    private BlockPos pos;
    @Nullable
    private Ingredient ingredient;
    private ItemStack diff;

    public PacketIncrementalWokUpdate() {
    }

    PacketIncrementalWokUpdate(BlockPos pos, @Nullable Ingredient ingredient, ItemStack diff) {
        this.pos = pos;
        this.ingredient = ingredient;
        this.diff = diff;
    }

    public void writeDataTo(ByteBuf buffer) {
        buffer.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.diff);
        if (this.ingredient != null) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)CuisinePersistenceCenter.serialize(this.ingredient));
        }
    }

    public void readDataFrom(ByteBuf buffer) {
        this.pos = BlockPos.func_177969_a((long)buffer.readLong());
        this.diff = ByteBufUtils.readItemStack((ByteBuf)buffer);
        if (!this.diff.func_190926_b()) {
            this.ingredient = CuisinePersistenceCenter.deserializeIngredient(ByteBufUtils.readTag((ByteBuf)buffer));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient(EntityPlayerSP player) {
        TileEntity tile = null;
        if (player.field_70170_p.func_175667_e(this.pos)) {
            tile = player.field_70170_p.func_175625_s(this.pos);
        }
        if (tile instanceof TileWok) {
            if (CulinaryHub.API_INSTANCE.isKnownIngredient(this.diff)) {
                ((TileWok)tile).ingredientsForRendering.put(this.ingredient, this.diff);
                for (int k = 0; k < 4; ++k) {
                    double x = (double)tile.func_174877_v().func_177958_n() + 0.5 + tile.func_145831_w().field_73012_v.nextGaussian() * 0.2;
                    double z = (double)tile.func_174877_v().func_177952_p() + tile.func_145831_w().field_73012_v.nextGaussian() * 0.2;
                    tile.func_145831_w().func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, x, (double)tile.func_174877_v().func_177956_o() + 0.25, z, 0.0, 0.1, 0.0, new int[0]);
                }
                tile.func_145831_w().func_184134_a((double)tile.func_174877_v().func_177958_n() + 0.5 + tile.func_145831_w().field_73012_v.nextGaussian() * 0.2, (double)tile.func_174877_v().func_177956_o() + 0.25, (double)tile.func_174877_v().func_177952_p() + 0.5 + tile.func_145831_w().field_73012_v.nextGaussian() * 0.2, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 1.0f, 1.0f, true);
            } else {
                ((TileWok)tile).ingredientsForRendering.clear();
                ((TileWok)tile).seasoningInfo = null;
            }
        }
    }

    public void handleServer(EntityPlayerMP player) {
    }
}

