/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.tiles;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.MathHelper;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.FuelHandler;
import snownee.cuisine.api.HeatHandler;
import snownee.kiwi.util.OreUtil;
import snownee.kiwi.util.definition.ItemDefinition;
import snownee.kiwi.util.definition.OreDictDefinition;

public class FuelHeatHandler
implements HeatHandler,
FuelHandler {
    public static final Map<ItemDefinition, FuelInfo> ITEM_FUELS = new HashMap<ItemDefinition, FuelInfo>();
    public static final Map<OreDictDefinition, FuelInfo> ORE_FUELS = new HashMap<OreDictDefinition, FuelInfo>();
    private float encouragement = 0.0f;
    private float burnTime = 0.0f;
    private float heat;
    private float minHeat;
    private float maxHeat;
    private float heatPower;
    private float radiation;

    public static FuelInfo registerFuel(ItemDefinition item, int level, int heat) {
        if (ITEM_FUELS.containsKey(item)) {
            return null;
        }
        return ITEM_FUELS.put(item, new FuelInfo(level, heat));
    }

    public static FuelInfo unregisterFuel(ItemDefinition item) {
        return ITEM_FUELS.remove(item);
    }

    public static FuelInfo registerFuel(OreDictDefinition ore, int level, int heat) {
        if (ORE_FUELS.containsKey(ore)) {
            return null;
        }
        return ORE_FUELS.put(ore, new FuelInfo(level, heat));
    }

    public static FuelInfo unregisterFuel(OreDictDefinition ore) {
        return ORE_FUELS.remove(ore);
    }

    public FuelHeatHandler() {
        this.heat = 0.0f;
        this.minHeat = 0.0f;
        this.maxHeat = 0.0f;
        this.heatPower = 0.0f;
        this.radiation = 0.0f;
    }

    public FuelHeatHandler(float minHeat, float maxHeat, float heatPower, float radiation) {
        this.minHeat = minHeat;
        this.maxHeat = maxHeat;
        this.heatPower = heatPower;
        this.radiation = radiation;
    }

    @Override
    public void update(float bonusRate) {
        if (this.burnTime > 0.0f) {
            this.burnTime -= (1.0f + bonusRate) * (1.0f + this.encouragement);
            this.encouragement = Math.max(this.encouragement - 0.01f, 0.0f);
            this.burnTime = MathHelper.func_76131_a((float)this.burnTime, (float)0.0f, (float)this.getMaxBurnTime());
            this.heat += this.getHeatPower();
        }
        this.heat -= this.radiation;
        this.heat = MathHelper.func_76131_a((float)this.heat, (float)this.minHeat, (float)this.getMaxHeat());
    }

    @Override
    public float getHeatPower() {
        return this.getBurnTime() > 0.0f ? this.getMaxHeatPower() : 0.0f;
    }

    @Override
    public float getMaxHeatPower() {
        return this.heatPower;
    }

    public void setHeatPower(float heatPower) {
        this.heatPower = heatPower;
    }

    public float getMinHeat() {
        return this.minHeat;
    }

    public void setMinHeat(float minHeat) {
        this.minHeat = minHeat;
    }

    public void setMaxHeat(float maxHeat) {
        this.maxHeat = maxHeat;
    }

    public float getRadiation() {
        return this.radiation;
    }

    public void setRadiation(float radiation) {
        this.radiation = radiation;
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(float heat) {
        this.heat = heat;
    }

    @Override
    public float getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void addHeat(float delta) {
        this.heat = MathHelper.func_76131_a((float)(this.heat + delta), (float)0.0f, (float)this.getMaxHeat());
    }

    public void encourage() {
        this.encouragement = MathHelper.func_76131_a((float)(this.encouragement + 0.5f), (float)0.0f, (float)1.0f);
    }

    @Override
    public float getBurnTime() {
        return this.burnTime;
    }

    @Override
    public void setBurnTime(float burnTime) {
        this.burnTime = burnTime;
    }

    public int getLevel() {
        if (this.burnTime == 0.0f) {
            return 0;
        }
        return (float)((int)(this.burnTime - 1.0f) / 1000) + this.encouragement > 0.0f ? 2 : 1;
    }

    @Override
    public float getMaxBurnTime() {
        return 3000.0f;
    }

    @Override
    public void addBurnTime(float delta) {
        this.burnTime = MathHelper.func_76131_a((float)(this.burnTime + delta), (float)0.0f, (float)this.getMaxBurnTime());
    }

    public ItemStack addFuel(ItemStack stack) {
        FuelInfo info = FuelHeatHandler.getFuel(stack = stack.func_77946_l());
        if (info != null) {
            int max = info.level * 1000;
            if (this.getHeat() + 20.0f < (float)max) {
                float newBurnTime = Math.min(this.burnTime + (float)info.heat, (float)max);
                this.setBurnTime(newBurnTime);
                stack.func_190918_g(1);
            }
        }
        return stack;
    }

    public static boolean isFuel(ItemStack stack, boolean useVanillaFuels) {
        if (stack.func_190926_b() || !stack.func_77973_b().getContainerItem(stack).func_190926_b()) {
            return false;
        }
        if (useVanillaFuels && TileEntityFurnace.func_145952_a((ItemStack)stack) > 0) {
            return true;
        }
        if (ITEM_FUELS.containsKey(ItemDefinition.of((ItemStack)stack))) {
            return true;
        }
        if (ITEM_FUELS.containsKey(ItemDefinition.of((Item)stack.func_77973_b(), (int)Short.MAX_VALUE))) {
            return true;
        }
        for (String ore : OreUtil.getOreNames((ItemStack)stack)) {
            if (!ORE_FUELS.containsKey(OreDictDefinition.of((String)ore))) continue;
            return true;
        }
        return false;
    }

    public static FuelInfo getFuel(ItemStack stack) {
        int burnTime;
        FuelInfo info = ITEM_FUELS.get(ItemDefinition.of((ItemStack)stack));
        if (info == null) {
            info = ITEM_FUELS.get(ItemDefinition.of((Item)stack.func_77973_b(), (int)Short.MAX_VALUE));
        }
        if (info == null) {
            String ore;
            Iterator iterator = OreUtil.getOreNames((ItemStack)stack).iterator();
            while (iterator.hasNext() && (info = ORE_FUELS.get(OreDictDefinition.of((String)(ore = (String)iterator.next())))) == null) {
            }
        }
        if (info == null && (burnTime = TileEntityFurnace.func_145952_a((ItemStack)stack)) > 0) {
            info = new FuelInfo(2, burnTime);
        }
        return info;
    }

    static {
        ITEM_FUELS.put(ItemDefinition.of((Item)Items.field_151072_bj), new FuelInfo(3, 1000));
        ITEM_FUELS.put(ItemDefinition.of((Item)Items.field_151044_h, (int)Short.MAX_VALUE), new FuelInfo(3, 800));
        ITEM_FUELS.put(ItemDefinition.of((Block)Blocks.field_150325_L, (int)Short.MAX_VALUE), new FuelInfo(1, 100));
        ITEM_FUELS.put(ItemDefinition.of((Block)Blocks.field_150404_cg, (int)Short.MAX_VALUE), new FuelInfo(1, 67));
        ITEM_FUELS.put(ItemDefinition.of((Block)CuisineRegistry.BAMBOO), new FuelInfo(1, 250));
        ORE_FUELS.put(OreDictDefinition.of((String)"fuelCoke"), new FuelInfo(3, 2000));
        ORE_FUELS.put(OreDictDefinition.of((String)"treeSapling"), new FuelInfo(1, 100));
        ORE_FUELS.put(OreDictDefinition.of((String)"paper"), new FuelInfo(1, 150));
        ORE_FUELS.put(OreDictDefinition.of((String)"sugarcane"), new FuelInfo(1, 100));
    }

    public static class FuelInfo {
        public final int level;
        public final int heat;

        public FuelInfo(int level, int heat) {
            this.level = level;
            this.heat = heat;
        }
    }
}

