/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.top;

import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import snownee.cuisine.blocks.BlockCuisineCrops;
import snownee.cuisine.blocks.BlockModLeaves;
import snownee.cuisine.blocks.BlockShearedLeaves;
import snownee.cuisine.util.I18nUtil;

public class CuisineCropProvider
implements IProbeInfoProvider {
    public String getID() {
        return "cuisine:crop";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (blockState.func_177230_c() instanceof BlockCuisineCrops) {
            if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowCropPercentage())) {
                int maxAge;
                BlockCuisineCrops crops = (BlockCuisineCrops)blockState.func_177230_c();
                int age = crops.getAge(blockState, (IBlockAccess)world, data.getPos());
                if (age == (maxAge = crops.getMaxAge())) {
                    probeInfo.text(TextStyleClass.OK + I18nUtil.translate("gui.fully_grown"));
                } else {
                    probeInfo.text(TextStyleClass.LABEL + I18nUtil.translate("gui.grown", TextStyleClass.WARNING + "" + age * 100 / maxAge));
                }
            }
        } else if (blockState.func_177230_c() instanceof BlockModLeaves) {
            if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowCropPercentage())) {
                probeInfo.text(I18nUtil.translate("gui.leaves." + blockState.func_177229_b((IProperty)BlockModLeaves.AGE)));
            }
        } else if (blockState.func_177230_c() instanceof BlockShearedLeaves && Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)Config.getRealConfig().getShowCropPercentage())) {
            probeInfo.text(I18nUtil.translate("gui.leaves.0"));
        }
    }
}

