/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.patchouli;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Effect;
import snownee.cuisine.plugins.patchouli.PageCenteredText;
import snownee.cuisine.plugins.patchouli.PageDrinkType;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.Kiwi;
import snownee.kiwi.client.AdvancedFontRenderer;
import snownee.kiwi.util.Util;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.util.ItemStackUtil;

@SideOnly(value=Side.CLIENT)
public class PatchouliClientHandler
implements IResourceManagerReloadListener {
    private FontRenderer originalFontRenderer;
    private static String parseError = "";
    private boolean loaded = false;

    PatchouliClientHandler() {
        ClientBookRegistry.INSTANCE.pageTypes.put("cuisine:centered_text", PageCenteredText.class);
        ClientBookRegistry.INSTANCE.pageTypes.put("cuisine:drink_type", PageDrinkType.class);
        PatchouliClientHandler.registerMacro((parameter, state) -> {
            String effectId;
            Effect effect;
            String firstKey;
            List<Tuple<String, String>> tuples = PatchouliClientHandler.parseParameters(parameter);
            if (!tuples.isEmpty() && (firstKey = (String)tuples.get(0).func_76341_a()).equals("effect") && (effect = CulinaryHub.API_INSTANCE.findEffect(effectId = (String)tuples.get(0).func_76340_b())) != null) {
                String description;
                String name = Util.color((int)state.book.linkColor) + I18n.func_135052_a((String)effect.getName(), (Object[])new Object[0]) + "\u00a7r";
                state.tooltip = description = Util.color((int)effect.getColor()) + I18n.func_135052_a((String)effect.getDescription(), (Object[])new Object[0]);
                return name;
            }
            state.tooltip = parameter;
            return parseError;
        }, "cuisine");
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_110542_a((IResourceManagerReloadListener)this);
        }
    }

    private static void registerMacro(BookTextParser.FunctionProcessor function, String ... names) {
        try {
            Method method = BookTextParser.class.getDeclaredMethod("register", BookTextParser.FunctionProcessor.class, String[].class);
            method.setAccessible(true);
            method.invoke(null, function, names);
        }
        catch (Exception e) {
            Kiwi.logger.debug("Cuisine failed to inject 3rd party marcos into Patchouli, exception:\n {}", (Throwable)e);
        }
    }

    private static List<Tuple<String, String>> parseParameters(String s) {
        String[] pairs = s.split("(?<!\\\\);");
        ArrayList<Tuple<String, String>> tuples = new ArrayList<Tuple<String, String>>(pairs.length);
        for (String pair : pairs) {
            String[] elements;
            if (pair.isEmpty() || (elements = pair.split("=", 2)).length != 2) continue;
            tuples.add((Tuple<String, String>)new Tuple((Object)elements[0], (Object)elements[1]));
        }
        return tuples;
    }

    private static String getParameter(List<Tuple<String, String>> tuples, String key) {
        for (Tuple<String, String> tuple : tuples) {
            if (!((String)tuple.func_76341_a()).equals(key)) continue;
            return (String)tuple.func_76340_b();
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpen(GuiOpenEvent event) {
        GuiScreen gui = event.getGui();
        if (gui == null && this.originalFontRenderer != null) {
            Minecraft.func_71410_x().field_71466_p = this.originalFontRenderer;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Pre event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiBook && gui.field_146289_q.getClass() != AdvancedFontRenderer.class) {
            parseError = "\u00a74" + I18nUtil.translate("manual.parseError") + "\u00a7r";
            gui.field_146289_q = AdvancedFontRenderer.INSTANCE;
            this.originalFontRenderer = Minecraft.func_71410_x().field_71466_p;
            Minecraft.func_71410_x().field_71466_p = gui.field_146289_q;
        }
    }

    public void reload() {
        Book book = (Book)BookRegistry.INSTANCE.books.get(new ResourceLocation("cuisine", "culinary_101"));
        if (book != null) {
            PatchouliClientHandler.registerSubtypesMapping(book, (Item)CuisineRegistry.CROPS, "preface/plant");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.BAMBOO), "preface/plant");
            PatchouliClientHandler.registerMapping(book, new ItemStack(Blocks.field_150458_ak), "preface/plant");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.WOODEN_BASIN), "processing/basin");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.EARTHEN_BASIN), "processing/basin");
            PatchouliClientHandler.registerSubtypesMapping(book, (Block)CuisineRegistry.EARTHEN_BASIN_COLORED, "processing/basin");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Item)CuisineRegistry.ITEM_MORTAR), "processing/mortar");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.JAR), "processing/jar");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.MILL), "processing/mill");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.CHOPPING_BOARD), "processing/chopping_board");
            PatchouliClientHandler.registerMapping(book, new ItemStack(Items.field_151067_bt), "utensils/brewing");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Item)CuisineRegistry.DISH), "utensils/plate");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.DRINKRO), "utensils/drinkro");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.FIRE_PIT, 1, 0), "utensils/fire_pit");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.FIRE_PIT, 1, 1), "utensils/wok");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.FIRE_PIT, 1, 2), "utensils/bbq_rack");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.FIRE_PIT, 1, 3), "utensils/frying_pan");
            PatchouliClientHandler.registerSubtypesMapping(book, (Block)CuisineRegistry.SHEARED_LEAVES, "misc/fruit_trees");
            PatchouliClientHandler.registerSubtypesMapping(book, (Block)CuisineRegistry.SAPLING, "misc/fruit_trees");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.LOG), "misc/fruit_trees");
            PatchouliClientHandler.registerMapping(book, new ItemStack((Block)CuisineRegistry.TOFU_BLOCK), "misc/tofu_block");
            PatchouliClientHandler.registerMapping(book, new ItemStack(Blocks.field_150367_z), "misc/wooden_arm");
        }
    }

    private static void registerMapping(Book book, ItemStack stack, String entry) {
        BookEntry bookEntry = (BookEntry)book.contents.entries.get(new ResourceLocation("cuisine", entry));
        if (bookEntry != null) {
            book.contents.recipeMappings.put(new ItemStackUtil.StackWrapper(stack), Pair.of((Object)bookEntry, (Object)0));
        }
    }

    private static void registerSubtypesMapping(Book book, Block block, String entry) {
        NonNullList items = NonNullList.func_191196_a();
        block.func_149666_a(block.func_149708_J(), items);
        for (ItemStack stack : items) {
            PatchouliClientHandler.registerMapping(book, stack, entry);
        }
    }

    private static void registerSubtypesMapping(Book book, Item item, String entry) {
        NonNullList items = NonNullList.func_191196_a();
        item.func_150895_a(item.func_77640_w(), items);
        for (ItemStack stack : items) {
            PatchouliClientHandler.registerMapping(book, stack, entry);
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        if (this.loaded) {
            this.reload();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!this.loaded) {
            this.loaded = true;
            this.reload();
        }
    }
}

