/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.patchouli;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.internal.food.Drink;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.util.NBTHelper;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;

public class PageDrinkType
extends BookPage {
    String drink_type;
    private transient Drink.DrinkType drinkType;
    private transient ItemStack drink;
    private transient List<ItemStack> containers;
    private transient List<List<ItemStack>> featureInputs;

    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.drinkType = Drink.DrinkType.get(this.drink_type);
        if (this.drinkType != null) {
            this.drink = new ItemStack((Item)CuisineRegistry.DRINK);
            NBTHelper.of((ItemStack)this.drink).setString("model", this.drinkType.getName()).setInt("liquidColor", 15763993);
            this.containers = this.drinkType.getContainerPre().examples();
            this.featureInputs = new ArrayList<List<ItemStack>>();
            for (Map.Entry<ProcessingInput, Drink.DrinkType> e : Drink.Builder.FEATURE_INPUTS.entrySet()) {
                List examples;
                if (e.getValue() != this.drinkType || (examples = e.getKey().examples()).isEmpty()) continue;
                this.featureInputs.add(examples);
            }
        }
    }

    public void render(int mouseX, int mouseY, float pticks) {
        if (this.drinkType == null) {
            return;
        }
        this.parent.drawCenteredStringNoShadow(I18n.func_135052_a((String)(this.drinkType.getTranslationKey() + ".name"), (Object[])new Object[0]), 58, -4, this.book.textColor);
        int w = 68;
        int h = 26;
        this.mc.field_71446_o.func_110577_a(this.book.craftingResource);
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)(58 - w / 2), (int)10, (float)0.0f, (float)(128 - h), (int)w, (int)h, (float)128.0f, (float)128.0f);
        this.parent.renderItemStack(49, 15, mouseX, mouseY, this.drink);
        if (this.drinkType != Drink.DrinkType.NORMAL) {
            this.parent.getFont().func_78276_b(I18nUtil.translate("manual.featureInput"), 4, 40, this.book.textColor);
        }
        this.parent.getFont().func_78276_b(I18nUtil.translate("manual.container"), 4, this.drinkType == Drink.DrinkType.NORMAL ? 40 : 80, this.book.textColor);
        this.parent.getFont().func_78276_b(I18nUtil.translate("manual.potionVege", I18n.func_135052_a((String)this.drinkType.getPotionVege().func_76393_a(), (Object[])new Object[0])), 4, 120, this.book.textColor);
        this.parent.getFont().func_78276_b(I18nUtil.translate("manual.potionFruit", I18n.func_135052_a((String)this.drinkType.getPotionFruit().func_76393_a(), (Object[])new Object[0])), 4, 130, this.book.textColor);
        int x = 0;
        for (List<ItemStack> inputs : this.featureInputs) {
            this.drawItems(x, 48, mouseX, mouseY, inputs);
            x += 24;
        }
        this.drawItems(0, this.drinkType == Drink.DrinkType.NORMAL ? 48 : 88, mouseX, mouseY, this.containers);
    }

    private void drawItems(int x, int y, int mouseX, int mouseY, List<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        this.drawItem(x, y, mouseX, mouseY, items.get(items.size() == 1 ? 0 : (int)(Minecraft.func_71386_F() / 1000L % (long)items.size())));
    }

    private void drawItem(int x, int y, int mouseX, int mouseY, ItemStack item) {
        int size = 26;
        this.mc.field_71446_o.func_110577_a(this.book.craftingResource);
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)x, (int)y, (float)20.0f, (float)(128 - size), (int)size, (int)size, (float)128.0f, (float)128.0f);
        this.parent.renderItemStack(x + 5, y + 5, mouseX, mouseY, item);
    }
}

