/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.nutrition;

import ca.wescook.nutrition.capabilities.INutrientManager;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import snownee.cuisine.Cuisine;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.MaterialCategory;
import snownee.cuisine.api.events.ConsumeCompositeFoodEvent;
import snownee.cuisine.internal.CuisinePersistenceCenter;
import snownee.kiwi.IModule;
import snownee.kiwi.KiwiModule;

@KiwiModule(modid="cuisine", name="nutrition", dependency="nutrition", optional=true)
public class NutritionCompat
implements IModule {
    private static Capability<INutrientManager> NUTRITION_CAPABILITY;
    public static final Map<MaterialCategory, Nutrient> materialCategoryToNutrient;

    static void injectCap(Capability<INutrientManager> capability) {
        NUTRITION_CAPABILITY = capability;
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void refreshData() {
        if (materialCategoryToNutrient.isEmpty()) {
            for (Nutrient nutrient : NutrientList.get()) {
                switch (nutrient.name) {
                    case "fruit": {
                        materialCategoryToNutrient.put(MaterialCategory.FRUIT, nutrient);
                        break;
                    }
                    case "grain": {
                        materialCategoryToNutrient.put(MaterialCategory.GRAIN, nutrient);
                        break;
                    }
                    case "vegetable": {
                        materialCategoryToNutrient.put(MaterialCategory.VEGETABLES, nutrient);
                        break;
                    }
                    case "protein": {
                        materialCategoryToNutrient.put(MaterialCategory.FISH, nutrient);
                        materialCategoryToNutrient.put(MaterialCategory.SEAFOOD, nutrient);
                        materialCategoryToNutrient.put(MaterialCategory.MEAT, nutrient);
                        materialCategoryToNutrient.put(MaterialCategory.NUT, nutrient);
                        materialCategoryToNutrient.put(MaterialCategory.PROTEIN, nutrient);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEatStuff(ConsumeCompositeFoodEvent.Post event) {
        EntityPlayer consumer = event.getConsumer();
        INutrientManager manager = (INutrientManager)consumer.getCapability(NUTRITION_CAPABILITY, null);
        if (manager == null) {
            Cuisine.logger.debug("Entity {} has no INutrientManager. Skip nutrition calculation.", (Object)consumer);
            return;
        }
        Object2DoubleArrayMap map = new Object2DoubleArrayMap();
        for (Ingredient ingredient : event.getFood().getIngredients()) {
            for (MaterialCategory category : ingredient.getMaterial().getCategories()) {
                map.put((Object)category, (Double)map.getOrDefault((Object)category, (Object)0.0) + 1.0);
            }
        }
        for (Object2DoubleMap.Entry entry : map.object2DoubleEntrySet()) {
            if (entry.getKey() == MaterialCategory.SUPERNATURAL) {
                manager.add(NutrientList.get(), (float)(entry.getDoubleValue() * (double)0.1f));
                continue;
            }
            if (!materialCategoryToNutrient.containsKey(entry.getKey())) continue;
            manager.add(materialCategoryToNutrient.get(entry.getKey()), (float)(entry.getDoubleValue() * 0.5));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        INutrientManager manager;
        Entity entity = event.getEntity();
        if (materialCategoryToNutrient.isEmpty()) {
            this.refreshData();
        }
        if ((manager = (INutrientManager)entity.getCapability(NUTRITION_CAPABILITY, null)) == null) {
            Cuisine.logger.debug("Entity {} has no INutrientManager. Skip nutrition calculation.", (Object)entity);
            return;
        }
        ItemStack item = event.getItem();
        if (item.func_77973_b() == CuisineRegistry.INGREDIENT) {
            NBTTagCompound data = item.func_77978_p();
            if (data == null) {
                return;
            }
            Ingredient ingredient = CuisinePersistenceCenter.deserializeIngredient(data);
            if (ingredient != null) {
                for (MaterialCategory category : ingredient.getMaterial().getCategories()) {
                    if (category == MaterialCategory.SUPERNATURAL) {
                        manager.add(NutrientList.get(), CuisineConfig.COMPAT.supernaturalNutrientModifier);
                        continue;
                    }
                    manager.add(materialCategoryToNutrient.get((Object)category), CuisineConfig.COMPAT.normalNutrientModifier);
                }
            }
        }
    }

    static {
        materialCategoryToNutrient = new HashMap<MaterialCategory, Nutrient>();
    }
}

