/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.plugins.jei.JEICompat;
import snownee.cuisine.plugins.jei.VesselRecipe;
import snownee.cuisine.util.I18nUtil;

public class VesselRecipeCategory
implements IRecipeCategory<VesselRecipe> {
    static final String UID = "cuisine.vessel";
    private static final ITooltipCallback<FluidStack> SOLVENT_TIP = (slotIndex, input, ingredient, tooltip) -> tooltip.add(I18nUtil.translate("tip.solvent"));
    private final IDrawable background;
    private final String localizedName;

    VesselRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("cuisine", "textures/gui/jei.png"), 36, 0, 130, 18);
        this.localizedName = I18n.func_135052_a((String)(CuisineRegistry.JAR.func_149739_a() + ".name"), (Object[])new Object[0]);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Cuisine";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, VesselRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        stacks.init(0, true, 0, 0);
        stacks.init(1, true, 36, 0);
        stacks.init(2, false, 94, 0);
        fluids.init(0, true, 19, 1, 16, 16, 100, false, null);
        if (recipeWrapper.recipe.getOutputFluid() != null) {
            fluids.init(1, false, recipeWrapper.recipe.getOutput().isEmpty() ? 95 : 113, 1, 16, 16, recipeWrapper.recipe.getOutputFluid().amount, false, null);
        } else {
            fluids.addTooltipCallback(SOLVENT_TIP);
        }
        stacks.set(ingredients);
        fluids.set(ingredients);
        stacks.addTooltipCallback(JEICompat.identifierTooltip(recipeWrapper.recipe.getIdentifier()));
        fluids.addTooltipCallback(JEICompat.identifierTooltip(recipeWrapper.recipe.getIdentifier()));
    }
}

