/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.plugins.jei.JEICompat;
import snownee.cuisine.plugins.jei.MillRecipe;

public class MillRecipeCategory
implements IRecipeCategory<MillRecipe> {
    public static final String UID = "cuisine.mill";
    private final IDrawable background;
    private final String localizedName;

    MillRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(new ResourceLocation("cuisine", "textures/gui/jei.png"), 54, 0, 112, 18);
        this.localizedName = I18n.func_135052_a((String)(CuisineRegistry.MILL.func_149739_a() + ".name"), (Object[])new Object[0]);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Cuisine";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout layout, MillRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        IGuiFluidStackGroup fluids = layout.getFluidStacks();
        stacks.init(0, true, 0, 0);
        if (recipe.recipe.getInputFluid() != null) {
            fluids.init(0, true, 19, 1, 16, 16, recipe.recipe.getInputFluid().amount, false, null);
        }
        if (recipe.recipe.getOutput().func_190926_b()) {
            if (recipe.recipe.getOutputFluid() != null) {
                fluids.init(1, false, 77, 1, 16, 16, recipe.recipe.getOutputFluid().amount, false, null);
            }
        } else {
            stacks.init(1, false, 76, 0);
            if (recipe.recipe.getOutputFluid() != null) {
                fluids.init(1, false, 95, 1, 16, 16, recipe.recipe.getOutputFluid().amount, false, null);
            }
        }
        stacks.set(ingredients);
        fluids.set(ingredients);
        stacks.addTooltipCallback(JEICompat.identifierTooltip(recipe.recipe.getIdentifier()));
        fluids.addTooltipCallback(JEICompat.identifierTooltip(recipe.recipe.getIdentifier()));
    }
}

