/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableBuilder;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import snownee.cuisine.CuisineConfig;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.Material;
import snownee.cuisine.api.process.BasinInteracting;
import snownee.cuisine.api.process.Boiling;
import snownee.cuisine.api.process.Chopping;
import snownee.cuisine.api.process.Grinding;
import snownee.cuisine.api.process.Milling;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.api.process.Vessel;
import snownee.cuisine.api.process.prefab.DistillationBoiling;
import snownee.cuisine.api.process.prefab.MaterialSqueezing;
import snownee.cuisine.api.process.prefab.SimpleSqueezing;
import snownee.cuisine.api.process.prefab.SimpleThrowing;
import snownee.cuisine.blocks.BlockChoppingBoard;
import snownee.cuisine.internal.CuisineInternalGateway;
import snownee.cuisine.items.ItemBasicFood;
import snownee.cuisine.items.ItemMortar;
import snownee.cuisine.plugins.jei.BasinSqueezingRecipeCategory;
import snownee.cuisine.plugins.jei.BasinThrowingRecipeCategory;
import snownee.cuisine.plugins.jei.BoilingRecipeCategory;
import snownee.cuisine.plugins.jei.ChoppingBoardAxeRecipe;
import snownee.cuisine.plugins.jei.ChoppingBoardKnifeRecipe;
import snownee.cuisine.plugins.jei.ChoppingBoardRecipeCategory;
import snownee.cuisine.plugins.jei.CombinedTimer;
import snownee.cuisine.plugins.jei.DistillationBoilingRecipe;
import snownee.cuisine.plugins.jei.FirepitFuelCategory;
import snownee.cuisine.plugins.jei.FirepitFuelRecipe;
import snownee.cuisine.plugins.jei.MaterialSqueezingRecipe;
import snownee.cuisine.plugins.jei.MillRecipe;
import snownee.cuisine.plugins.jei.MillRecipeCategory;
import snownee.cuisine.plugins.jei.MortarGenericRecipe;
import snownee.cuisine.plugins.jei.MortarPasteRecipe;
import snownee.cuisine.plugins.jei.MortarRecipeCategory;
import snownee.cuisine.plugins.jei.RecipeChoppingBoardWrapper;
import snownee.cuisine.plugins.jei.RecipeSpiceBottleFillingWrapper;
import snownee.cuisine.plugins.jei.SimpleSqueezingRecipe;
import snownee.cuisine.plugins.jei.SimpleThrowingRecipe;
import snownee.cuisine.plugins.jei.VesselRecipe;
import snownee.cuisine.plugins.jei.VesselRecipeCategory;
import snownee.cuisine.tiles.FuelHeatHandler;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.util.definition.ItemDefinition;
import snownee.kiwi.util.definition.OreDictDefinition;

@JEIPlugin
public class JEICompat
implements IModPlugin {
    static final ResourceLocation VANILLA_RECIPE_GUI = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    static final ResourceLocation CUISINE_RECIPE_GUI = new ResourceLocation("cuisine", "textures/gui/jei.png");
    static List<ItemStack> AXES;
    static IDrawable arrowOut;
    static IDrawable arrowOutOverlay;
    static IDrawable arrowIn;
    static IDrawable arrowInOverlay;
    static IDrawableStatic arrowInOverlayStatic;

    public static void updateAxesList(String[] axeIds) {
        AXES = Arrays.stream(axeIds).map(id -> ItemDefinition.parse((String)id, (boolean)false)).map(ItemDefinition::getItemStack).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    public void register(IModRegistry registry) {
        void var6_10;
        if (CuisineConfig.GENERAL.axeChopping) {
            JEICompat.updateAxesList(CuisineConfig.CLIENT.axeList);
        }
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        arrowOut = guiHelper.createDrawable(CUISINE_RECIPE_GUI, 11, 26, 11, 7);
        arrowOutOverlay = guiHelper.drawableBuilder(CUISINE_RECIPE_GUI, 11, 18, 11, 8).buildAnimated((ITickTimer)new CombinedTimer(80, 11, 11, 22), IDrawableAnimated.StartDirection.LEFT);
        arrowIn = guiHelper.createDrawable(CUISINE_RECIPE_GUI, 0, 26, 11, 7);
        IDrawableBuilder builder = guiHelper.drawableBuilder(CUISINE_RECIPE_GUI, 0, 18, 11, 8);
        arrowInOverlayStatic = builder.build();
        arrowInOverlay = builder.buildAnimated((ITickTimer)new CombinedTimer(80, 0, 11, 22), IDrawableAnimated.StartDirection.LEFT);
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)CuisineRegistry.INGREDIENT));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)CuisineRegistry.DRINK));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)new ItemStack((Item)CuisineRegistry.BOTTLE));
        registry.getJeiHelpers().getIngredientBlacklist().addIngredientToBlacklist((Object)CuisineRegistry.BASIC_FOOD.getItemStack(ItemBasicFood.Variant.EMPOWERED_CITRON));
        if (ForgeRegistries.RECIPES.containsKey(new ResourceLocation("cuisine", "chopping_board"))) {
            registry.addRecipes((Collection)BlockChoppingBoard.getSuitableCovers().stream().map(RecipeChoppingBoardWrapper::new).collect(Collectors.toList()), "minecraft.crafting");
        }
        registry.addRecipes((Collection)CuisineInternalGateway.INSTANCE.itemToSpiceMapping.keySet().stream().map(RecipeSpiceBottleFillingWrapper::new).collect(Collectors.toList()), "minecraft.crafting");
        registry.addRecipes((Collection)CuisineInternalGateway.INSTANCE.oreDictToSpiceMapping.keySet().stream().map(OreDictDefinition::of).map(RecipeSpiceBottleFillingWrapper::new).collect(Collectors.toList()), "minecraft.crafting");
        BlockChoppingBoard.getSuitableCovers().stream().map(CuisineRegistry.CHOPPING_BOARD::getItemStack).forEach(stack -> registry.addRecipeCatalyst(stack, new String[]{"cuisine.chopping_board"}));
        IdentityHashMap<Material, List> reverseMaterialMapWithoutJuice = new IdentityHashMap<Material, List>();
        for (Map.Entry<ItemDefinition, Ingredient> entry : CuisineInternalGateway.INSTANCE.itemIngredients.entrySet()) {
            if (entry.getValue().getForm() == Form.JUICE) continue;
            reverseMaterialMapWithoutJuice.computeIfAbsent(entry.getValue().getMaterial(), m -> new ArrayList()).addAll(entry.getKey().examples());
        }
        for (Map.Entry<Object, Ingredient> entry : CuisineInternalGateway.INSTANCE.oreDictIngredients.entrySet()) {
            if (entry.getValue().getForm() == Form.JUICE) continue;
            reverseMaterialMapWithoutJuice.computeIfAbsent(entry.getValue().getMaterial(), m -> new ArrayList()).addAll(OreDictionary.getOres((String)((String)entry.getKey())));
        }
        ArrayList<Object> recipes = new ArrayList<Object>();
        CuisineInternalGateway.INSTANCE.itemIngredients.forEach((k, v) -> {
            if (v.getForm() == Form.FULL && !v.getMaterial().getValidForms().isEmpty() && !v.getMaterial().getValidForms().equals(Form.JUICE_ONLY)) {
                recipes.add(new ChoppingBoardKnifeRecipe((ProcessingInput)k, v.getMaterial()));
            }
        });
        CuisineInternalGateway.INSTANCE.oreDictIngredients.forEach((k, v) -> {
            if (!(v.getForm() != Form.FULL || v.getMaterial().getValidForms().isEmpty() || v.getMaterial().getValidForms().equals(Form.JUICE_ONLY) || OreDictionary.getOres((String)k, (boolean)false).isEmpty())) {
                recipes.add(new ChoppingBoardKnifeRecipe((ProcessingInput)OreDictDefinition.of((String)k), v.getMaterial()));
            }
        });
        if (CuisineConfig.GENERAL.axeChopping) {
            Processing.CHOPPING.preview().forEach(recipe -> recipes.add(new ChoppingBoardAxeRecipe((Chopping)recipe)));
        }
        registry.addRecipes(recipes, "cuisine.chopping_board");
        recipes.clear();
        registry.addRecipeCatalyst((Object)CuisineRegistry.ITEM_MORTAR.getItemStack(ItemMortar.Variant.EMPTY), new String[]{"cuisine.mortar"});
        Processing.GRINDING.preview().forEach(recipe -> recipes.add(new MortarGenericRecipe((Grinding)recipe)));
        CuisineInternalGateway.INSTANCE.itemIngredients.forEach((k, v) -> {
            if (v.getForm() != Form.PASTE && v.getForm() != Form.JUICE && v.getMaterial().isValidForm(Form.PASTE) && Processing.GRINDING.findRecipe(k.getItemStack()) == null) {
                recipes.add(new MortarPasteRecipe((ProcessingInput)k, v.getMaterial()));
            }
        });
        CuisineInternalGateway.INSTANCE.oreDictIngredients.forEach((k, v) -> {
            if (v.getForm() != Form.PASTE && v.getForm() != Form.JUICE && v.getMaterial().isValidForm(Form.PASTE) && !OreDictionary.getOres((String)k, (boolean)false).isEmpty() && Processing.GRINDING.findRecipe(OreDictDefinition.of((String)k).getItemStack()) == null) {
                recipes.add(new MortarPasteRecipe((ProcessingInput)OreDictDefinition.of((String)k), v.getMaterial()));
            }
        });
        registry.addRecipes(recipes, "cuisine.mortar");
        recipes.clear();
        registry.addRecipeCatalyst((Object)new ItemStack((Block)CuisineRegistry.MILL), new String[]{"cuisine.mill"});
        registry.handleRecipes(Milling.class, MillRecipe::new, "cuisine.mill");
        registry.addRecipes(Processing.MILLING.preview(), "cuisine.mill");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)CuisineRegistry.JAR), new String[]{"cuisine.vessel"});
        registry.handleRecipes(Vessel.class, VesselRecipe::new, "cuisine.vessel");
        registry.addRecipes(Processing.VESSEL.preview(), "cuisine.vessel");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)CuisineRegistry.WOODEN_BASIN), new String[]{"cuisine.basin_squeezing", "cuisine.basin_throwing"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)CuisineRegistry.EARTHEN_BASIN), new String[]{"cuisine.basin_squeezing", "cuisine.basin_throwing", "cuisine.basin_boiling"});
        boolean bl = false;
        while (var6_10 < CuisineRegistry.EARTHEN_BASIN_COLORED.getItemSubtypeAmount()) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)CuisineRegistry.EARTHEN_BASIN_COLORED, 1, (int)var6_10), new String[]{"cuisine.basin_squeezing", "cuisine.basin_throwing", "cuisine.basin_boiling"});
            ++var6_10;
        }
        for (BasinInteracting basinInteracting : Processing.SQUEEZING.preview()) {
            if (basinInteracting instanceof SimpleSqueezing) {
                recipes.add(new SimpleSqueezingRecipe((SimpleSqueezing)basinInteracting));
                continue;
            }
            if (!(basinInteracting instanceof MaterialSqueezing) || ((MaterialSqueezing)basinInteracting).getMaterial() == CulinaryHub.CommonMaterials.EMPOWERED_CITRON) continue;
            recipes.add(new MaterialSqueezingRecipe((MaterialSqueezing)basinInteracting, (Collection)reverseMaterialMapWithoutJuice.get(((MaterialSqueezing)basinInteracting).getMaterial())));
        }
        registry.addRecipes(recipes, "cuisine.basin_squeezing");
        recipes.clear();
        for (BasinInteracting basinInteracting : Processing.BASIN_THROWING.preview()) {
            if (!(basinInteracting instanceof SimpleThrowing)) continue;
            recipes.add(new SimpleThrowingRecipe((SimpleThrowing)basinInteracting));
        }
        registry.addRecipes(recipes, "cuisine.basin_throwing");
        recipes.clear();
        for (Boiling boiling : Processing.BOILING.preview()) {
            if (!(boiling instanceof DistillationBoiling)) continue;
            recipes.add(new DistillationBoilingRecipe((DistillationBoiling)boiling));
        }
        registry.addRecipes(recipes, "cuisine.basin_boiling");
        recipes.clear();
        registry.addRecipeCatalyst((Object)new ItemStack((Block)CuisineRegistry.FIRE_PIT, 1, 1), new String[]{"cuisine.firepit_fuel"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)CuisineRegistry.FIRE_PIT, 1, 2), new String[]{"cuisine.firepit_fuel"});
        for (Map.Entry<ItemDefinition, FuelHeatHandler.FuelInfo> entry : FuelHeatHandler.ITEM_FUELS.entrySet()) {
            recipes.add(new FirepitFuelRecipe(guiHelper, (ProcessingInput)entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<OreDictDefinition, FuelHeatHandler.FuelInfo> entry : FuelHeatHandler.ORE_FUELS.entrySet()) {
            recipes.add(new FirepitFuelRecipe(guiHelper, (ProcessingInput)entry.getKey(), entry.getValue()));
        }
        for (ItemStack itemStack : registry.getIngredientRegistry().getFuels()) {
            if (itemStack.func_190926_b() || !itemStack.func_77973_b().getContainerItem(itemStack).func_190926_b() || FuelHeatHandler.isFuel(itemStack, false)) continue;
            recipes.add(new FirepitFuelRecipe(guiHelper, (ProcessingInput)ItemDefinition.of((ItemStack)itemStack), FuelHeatHandler.getFuel(itemStack)));
        }
        registry.addRecipes(recipes, "cuisine.firepit_fuel");
        recipes.clear();
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        IDrawableStatic basin = guiHelper.createDrawable(CUISINE_RECIPE_GUI, 0, 33, 20, 10);
        registry.addRecipeCategories(new IRecipeCategory[]{new ChoppingBoardRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MortarRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MillRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new VesselRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BoilingRecipeCategory(guiHelper, (IDrawable)basin)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BasinSqueezingRecipeCategory(guiHelper, (IDrawable)basin)});
        registry.addRecipeCategories(new IRecipeCategory[]{new BasinThrowingRecipeCategory(guiHelper, (IDrawable)basin)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FirepitFuelCategory(guiHelper)});
    }

    static <T> ITooltipCallback<T> identifierTooltip(ResourceLocation locator) {
        return (slot, isInput, ingredient, tooltip) -> {
            if (!isInput && (Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n())) {
                String text = locator.func_110624_b().equals("crafttweaker") ? I18n.func_135052_a((String)"jei.tooltip.recipe.by", (Object[])new Object[]{"CraftTweaker"}) : I18n.func_135052_a((String)"jei.tooltip.recipe.id", (Object[])new Object[]{locator});
                tooltip.add(TextFormatting.DARK_GRAY + text);
            }
        };
    }
}

