/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.jei;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.util.Collections;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import snownee.cuisine.plugins.jei.JEICompat;
import snownee.cuisine.tiles.FuelHeatHandler;
import snownee.cuisine.util.I18nUtil;
import snownee.kiwi.crafting.input.ProcessingInput;

public class FirepitFuelRecipe
implements IRecipeWrapper {
    private final ProcessingInput input;
    private final IDrawableAnimated flame;
    private final String burnHeatString;
    private final String burnLevelString;

    public FirepitFuelRecipe(IGuiHelper guiHelper, ProcessingInput input, FuelHeatHandler.FuelInfo fuelInfo) {
        Preconditions.checkArgument((fuelInfo.heat > 0 ? 1 : 0) != 0, (Object)"burn heat must be greater than 0");
        Preconditions.checkArgument((fuelInfo.level > 0 ? 1 : 0) != 0, (Object)"burn level must be greater than 0");
        this.input = input;
        this.burnHeatString = I18nUtil.translate("gui.jei.brun_heat", fuelInfo.heat);
        this.burnLevelString = I18nUtil.translate("gui.jei.brun_level", fuelInfo.level);
        this.flame = guiHelper.drawableBuilder(JEICompat.VANILLA_RECIPE_GUI, 82, 114, 14, 14).buildAnimated(fuelInfo.level * 30, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(this.input.examples()));
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.flame.draw(minecraft, 1, 0);
        minecraft.field_71466_p.func_78276_b(this.burnHeatString, 24, 7, Color.gray.getRGB());
        minecraft.field_71466_p.func_78276_b(this.burnLevelString, 24, 20, Color.gray.getRGB());
    }
}

