/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Material;
import snownee.cuisine.items.ItemIngredient;
import snownee.kiwi.crafting.input.ProcessingInput;

public class ChoppingBoardKnifeRecipe
implements IRecipeWrapper {
    private final List<ItemStack> knifes = new ArrayList<ItemStack>();
    private final ProcessingInput input;
    private final Material output;

    ChoppingBoardKnifeRecipe(ProcessingInput input, Material material) {
        this.input = input;
        this.output = material;
        this.knifes.addAll((Collection<ItemStack>)OreDictionary.getOres((String)"itemFoodCutter", (boolean)false));
        if (this.knifes.isEmpty()) {
            this.knifes.add(new ItemStack((Item)CuisineRegistry.KITCHEN_KNIFE));
        }
    }

    public void getIngredients(IIngredients ingredients) {
        List examples = this.input.examples();
        if ((examples = examples.stream().filter(i -> CulinaryHub.API_INSTANCE.findMaterial((ItemStack)i) == this.output).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        ingredients.setInputLists(VanillaTypes.ITEM, Arrays.asList(examples, this.knifes));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(ItemIngredient.getAllValidFormsWithException(this.output, EnumSet.of(Form.FULL, Form.JUICE))));
    }
}

