/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.config.Constants;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.plugins.jei.GenericRecipeWrapper;
import snownee.cuisine.plugins.jei.JEICompat;
import snownee.cuisine.util.I18nUtil;

public class BoilingRecipeCategory
implements IRecipeCategory<GenericRecipeWrapper> {
    static final String UID = "cuisine.basin_boiling";
    protected final IGuiHelper guiHelper;
    protected final IDrawable background;
    protected final IDrawable flame;
    protected final IDrawable container;
    protected final IDrawable flameOverlay;
    protected final String localizedName;

    public BoilingRecipeCategory(IGuiHelper guiHelper, IDrawable container) {
        this.guiHelper = guiHelper;
        this.container = container;
        this.background = guiHelper.createBlankDrawable(95, 32);
        this.flame = guiHelper.createDrawable(JEICompat.VANILLA_RECIPE_GUI, 2, 135, 13, 13);
        this.flameOverlay = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 82, 114, 14, 14);
        this.localizedName = I18nUtil.translate("gui.jei.title.basin_boiling");
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Cuisine";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.flame.draw(minecraft, 32, 1);
        this.flameOverlay.draw(minecraft, 31, 0);
        this.container.draw(minecraft, 0, 22);
        this.container.draw(minecraft, 56, 22);
    }

    public void setRecipe(IRecipeLayout recipeLayout, GenericRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        stacks.init(0, true, 1, 0);
        stacks.init(1, true, 29, 14);
        stacks.init(2, false, 77, 0);
        int maxAmount = 0;
        ArrayList lists = Lists.newArrayList((Iterable)ingredients.getInputs(VanillaTypes.FLUID));
        lists.addAll(ingredients.getOutputs(VanillaTypes.FLUID));
        for (List fluidStacks : lists) {
            for (FluidStack fluidStack : fluidStacks) {
                if (fluidStack == null || fluidStack.amount <= maxAmount) continue;
                maxAmount = fluidStack.amount;
            }
        }
        fluids.init(0, true, 2, 22, 16, 8, maxAmount, false, null);
        fluids.init(1, false, 58, 22, 16, 8, maxAmount, false, null);
        if (!ingredients.getInputs(VanillaTypes.ITEM).isEmpty() && !((List)ingredients.getInputs(VanillaTypes.ITEM).get(0)).isEmpty()) {
            stacks.setBackground(0, (IDrawable)this.guiHelper.getSlotDrawable());
        }
        stacks.setBackground(1, (IDrawable)this.guiHelper.getSlotDrawable());
        if (!ingredients.getOutputs(VanillaTypes.ITEM).isEmpty() && !((List)ingredients.getOutputs(VanillaTypes.ITEM).get(0)).isEmpty()) {
            stacks.setBackground(2, (IDrawable)this.guiHelper.getSlotDrawable());
        }
        stacks.set(ingredients);
        fluids.set(ingredients);
        stacks.addTooltipCallback(JEICompat.identifierTooltip(recipeWrapper.recipe.getIdentifier()));
        fluids.addTooltipCallback(JEICompat.identifierTooltip(recipeWrapper.recipe.getIdentifier()));
    }
}

