/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.plugins.jei.GenericRecipeWrapper;
import snownee.cuisine.plugins.jei.JEICompat;
import snownee.cuisine.util.I18nUtil;

public class BasinSqueezingRecipeCategory
implements IRecipeCategory<GenericRecipeWrapper> {
    static final String UID = "cuisine.basin_squeezing";
    protected final IGuiHelper guiHelper;
    protected final IDrawable background;
    protected final IDrawable container;
    protected final IDrawable arrow;
    protected final IDrawable arrowOverlay;
    protected final String localizedName;

    public BasinSqueezingRecipeCategory(IGuiHelper guiHelper, IDrawable container) {
        this.guiHelper = guiHelper;
        this.container = container;
        this.background = guiHelper.createBlankDrawable(74, 32);
        this.arrow = guiHelper.createDrawable(JEICompat.VANILLA_RECIPE_GUI, 25, 133, 22, 15);
        this.arrowOverlay = guiHelper.drawableBuilder(JEICompat.VANILLA_RECIPE_GUI, 82, 128, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = I18nUtil.translate("gui.jei.title.basin_squeezing");
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Cuisine";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.container.draw(minecraft, 0, 22);
        this.container.draw(minecraft, 54, 22);
        this.arrow.draw(minecraft, 26, 10);
        this.arrowOverlay.draw(minecraft, 26, 10);
    }

    public void setRecipe(IRecipeLayout recipeLayout, GenericRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        stacks.init(0, true, 1, 0);
        if (!ingredients.getInputs(VanillaTypes.ITEM).isEmpty() && !((List)ingredients.getInputs(VanillaTypes.ITEM).get(0)).isEmpty()) {
            stacks.setBackground(0, (IDrawable)this.guiHelper.getSlotDrawable());
        }
        stacks.init(1, false, 55, 0);
        if (!ingredients.getInputs(VanillaTypes.ITEM).isEmpty() && !((List)ingredients.getInputs(VanillaTypes.ITEM).get(0)).isEmpty()) {
            stacks.setBackground(0, (IDrawable)this.guiHelper.getSlotDrawable());
        }
        int maxAmount = 0;
        ArrayList lists = Lists.newArrayList((Iterable)ingredients.getInputs(VanillaTypes.FLUID));
        lists.addAll(ingredients.getOutputs(VanillaTypes.FLUID));
        for (List fluidStacks : lists) {
            for (FluidStack fluidStack : fluidStacks) {
                if (fluidStack == null || fluidStack.amount <= maxAmount) continue;
                maxAmount = fluidStack.amount;
            }
        }
        fluids.init(0, true, 2, 22, 16, 8, maxAmount, false, null);
        fluids.init(1, false, 56, 22, 16, 8, maxAmount, false, null);
        stacks.set(ingredients);
        fluids.set(ingredients);
        stacks.addTooltipCallback(JEICompat.identifierTooltip(recipeWrapper.recipe.getIdentifier()));
        fluids.addTooltipCallback(JEICompat.identifierTooltip(recipeWrapper.recipe.getIdentifier()));
    }
}

