/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.immersiveengineering;

import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.items.ItemCrops;
import snownee.kiwi.util.OreUtil;

public class CuisinePlantHandler
implements BelljarHandler.IPlantHandler {
    private final ItemCrops.Variant variant;

    public CuisinePlantHandler(ItemCrops.Variant variant) {
        this.variant = variant;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
        if (this.variant == ItemCrops.Variant.BAMBOO_SHOOT) {
            return new IBlockState[]{this.variant.getValue().getBlock().func_176223_P()};
        }
        int meta = MathHelper.func_76125_a((int)((int)(growth * 8.0f)), (int)0, (int)7);
        return new IBlockState[]{this.variant.getValue().getBlock().func_176203_a(meta)};
    }

    public boolean isValid(ItemStack seed) {
        return seed.func_77973_b() == CuisineRegistry.CROPS && seed.func_77960_j() == this.variant.getMeta();
    }

    public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
        return 0.003125f * fertilizer;
    }

    public ItemStack[] getOutput(ItemStack seed, ItemStack soil, TileEntity tile) {
        ItemStack output = this.variant == ItemCrops.Variant.BAMBOO_SHOOT ? new ItemStack((Block)CuisineRegistry.BAMBOO, 2) : ItemHandlerHelper.copyStackWithSize((ItemStack)seed, (int)2);
        return new ItemStack[]{output};
    }

    public boolean isCorrectSoil(ItemStack seed, ItemStack soil) {
        switch (this.variant.getValue().getPlantType()) {
            case Crop: 
            case Plains: 
            case Water: {
                return soil.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d) || soil.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150458_ak) || OreUtil.doesItemHaveOreName((ItemStack)soil, (String)"dirt");
            }
            case Beach: 
            case Desert: {
                return soil.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m) || OreUtil.doesItemHaveOreName((ItemStack)soil, (String)"sand");
            }
            case Cave: {
                return soil.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150348_b) || soil.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e) || OreUtil.doesItemHaveOreName((ItemStack)soil, (String)"stone") || OreUtil.doesItemHaveOreName((ItemStack)soil, (String)"cobblestone");
            }
            case Nether: {
                return soil.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150425_aM);
            }
        }
        return false;
    }
}

