/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.hwyla;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import snownee.cuisine.blocks.BlockCuisineCrops;
import snownee.cuisine.blocks.BlockModLeaves;
import snownee.cuisine.blocks.BlockShearedLeaves;
import snownee.cuisine.util.I18nUtil;

final class CuisineCropProvider
implements IWailaDataProvider {
    CuisineCropProvider() {
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (config.getConfig("general.showcrop")) {
            IBlockState target = accessor.getBlockState();
            if (accessor.getBlock() instanceof BlockCuisineCrops) {
                int maxAge;
                BlockCuisineCrops cropBlock = (BlockCuisineCrops)accessor.getBlock();
                int age = cropBlock.getAge(target, (IBlockAccess)accessor.getWorld(), accessor.getPosition());
                if (age == (maxAge = cropBlock.getMaxAge())) {
                    tooltip.add(TextFormatting.GREEN + I18nUtil.translate("gui.fully_grown"));
                } else {
                    tooltip.add(TextFormatting.GRAY + I18nUtil.translate("gui.grown", TextFormatting.YELLOW + "" + age * 100 / maxAge));
                }
            } else if (accessor.getBlock() instanceof BlockModLeaves) {
                tooltip.add(I18nUtil.translate("gui.leaves." + accessor.getBlockState().func_177229_b((IProperty)BlockModLeaves.AGE)));
            } else if (accessor.getBlock() instanceof BlockShearedLeaves) {
                tooltip.add(I18nUtil.translate("gui.leaves.0"));
            }
        }
        return tooltip;
    }
}

