/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.hwyla;

import java.text.MessageFormat;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.tiles.TileBasinHeatable;
import snownee.cuisine.util.I18nUtil;

final class CuisineBasinProvider
implements IWailaDataProvider {
    CuisineBasinProvider() {
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getTileEntity() instanceof TileBasinHeatable) {
            FluidStack fluidContent;
            NBTTagCompound data = accessor.getNBTData();
            boolean working = data.func_74767_n("working");
            if (working) {
                MessageFormat formatter = new MessageFormat(I18nUtil.translate("gui.progress"), MinecraftForgeClient.getLocale());
                int tick = data.func_74762_e("tick");
                tooltip.add(TextFormatting.GRAY + formatter.format(new Object[]{Float.valueOf((float)tick / (float)TileBasinHeatable.HEATING_TICK)}));
            }
            if ((fluidContent = FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_74775_l("fluidContent"))) != null) {
                tooltip.add(TextFormatting.GRAY + I18nUtil.translate("gui.fluid_show", fluidContent.getLocalizedName(), fluidContent.amount));
            }
        }
        return tooltip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te instanceof TileBasinHeatable) {
            FluidStack fluid = ((TileBasinHeatable)te).getCurrentFluidContent();
            if (fluid != null) {
                tag.func_74782_a("fluidContent", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
            }
            tag.func_74768_a("tick", ((TileBasinHeatable)te).getCurrentHeatingTick());
            tag.func_74757_a("working", ((TileBasinHeatable)te).getCurrentHeatingRecipe() != null);
        }
        return tag;
    }
}

