/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.api.process.CuisineProcessingRecipeManager;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.api.process.Vessel;
import snownee.cuisine.plugins.crafttweaker.CTSupport;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.util.definition.ItemDefinition;
import snownee.kiwi.util.definition.OreDictDefinition;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.cuisine.Vessel")
@ZenRegister
public class CTVessel {
    @ZenMethod
    public static void add(IItemStack input, ILiquidStack inputFluid, IItemStack output, ILiquidStack outputFluid, IItemStack extra) {
        ItemDefinition actualInput = ItemDefinition.of((ItemStack)CTSupport.toNative(input));
        ItemDefinition actualOutput = ItemDefinition.of((ItemStack)CTSupport.toNative(output));
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        FluidStack actualOutputFluid = CTSupport.toNative(outputFluid);
        ItemDefinition actualExtra = ItemDefinition.of((ItemStack)CTSupport.toNative(extra));
        CTSupport.DELAYED_ACTIONS.add(new Addition((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)actualExtra, actualOutput, actualOutputFluid));
    }

    @ZenMethod
    public static void add(IItemStack input, ILiquidStack inputFluid, IItemStack output, ILiquidStack outputFluid, IOreDictEntry extra) {
        ItemDefinition actualInput = ItemDefinition.of((ItemStack)CTSupport.toNative(input));
        ItemDefinition actualOutput = ItemDefinition.of((ItemStack)CTSupport.toNative(output));
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        FluidStack actualOutputFluid = CTSupport.toNative(outputFluid);
        OreDictDefinition actualExtra = CTSupport.fromOreEntry(extra);
        CTSupport.DELAYED_ACTIONS.add(new Addition((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)actualExtra, actualOutput, actualOutputFluid));
    }

    @ZenMethod
    public static void add(IOreDictEntry input, ILiquidStack inputFluid, IItemStack output, ILiquidStack outputFluid, IItemStack extra) {
        OreDictDefinition actualInput = CTSupport.fromOreEntry(input);
        ItemDefinition actualOutput = ItemDefinition.of((ItemStack)CTSupport.toNative(output));
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        FluidStack actualOutputFluid = CTSupport.toNative(outputFluid);
        ItemDefinition actualExtra = ItemDefinition.of((ItemStack)CTSupport.toNative(extra));
        CTSupport.DELAYED_ACTIONS.add(new Addition((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)actualExtra, actualOutput, actualOutputFluid));
    }

    @ZenMethod
    public static void add(IOreDictEntry input, ILiquidStack inputFluid, IItemStack output, ILiquidStack outputFluid, IOreDictEntry extra) {
        OreDictDefinition actualInput = CTSupport.fromOreEntry(input);
        ItemDefinition actualOutput = ItemDefinition.of((ItemStack)CTSupport.toNative(output));
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        FluidStack actualOutputFluid = CTSupport.toNative(outputFluid);
        OreDictDefinition actualExtra = CTSupport.fromOreEntry(extra);
        CTSupport.DELAYED_ACTIONS.add(new Addition((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)actualExtra, actualOutput, actualOutputFluid));
    }

    @ZenMethod
    public static void add(IItemStack input, ILiquidStack inputFluid, IItemStack output, ILiquidStack outputFluid) {
        ItemDefinition actualInput = ItemDefinition.of((ItemStack)CTSupport.toNative(input));
        ItemDefinition actualOutput = ItemDefinition.of((ItemStack)CTSupport.toNative(output));
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        FluidStack actualOutputFluid = CTSupport.toNative(outputFluid);
        CTSupport.DELAYED_ACTIONS.add(new Addition((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)ItemDefinition.EMPTY, actualOutput, actualOutputFluid));
    }

    @ZenMethod
    public static void add(IOreDictEntry input, ILiquidStack inputFluid, IItemStack output, ILiquidStack outputFluid) {
        OreDictDefinition actualInput = CTSupport.fromOreEntry(input);
        ItemDefinition actualOutput = ItemDefinition.of((ItemStack)CTSupport.toNative(output));
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        FluidStack actualOutputFluid = CTSupport.toNative(outputFluid);
        CTSupport.DELAYED_ACTIONS.add(new Addition((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)ItemDefinition.EMPTY, actualOutput, actualOutputFluid));
    }

    @ZenMethod
    public static void remove(IItemStack input, ILiquidStack inputFluid, IItemStack extra) {
        ItemDefinition actualInput = ItemDefinition.of((ItemStack)CTSupport.toNative(input));
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        ItemDefinition actualExtra = ItemDefinition.of((ItemStack)CTSupport.toNative(extra));
        CTSupport.DELAYED_ACTIONS.add(new Removal((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)actualExtra));
    }

    @ZenMethod
    public static void remove(IItemStack input, ILiquidStack inputFluid, IOreDictEntry extra) {
        ItemDefinition actualInput = ItemDefinition.of((ItemStack)CTSupport.toNative(input));
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        OreDictDefinition actualExtra = CTSupport.fromOreEntry(extra);
        CTSupport.DELAYED_ACTIONS.add(new Removal((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)actualExtra));
    }

    @ZenMethod
    public static void remove(IOreDictEntry input, ILiquidStack inputFluid, IItemStack extra) {
        OreDictDefinition actualInput = CTSupport.fromOreEntry(input);
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        ItemDefinition actualExtra = ItemDefinition.of((ItemStack)CTSupport.toNative(extra));
        CTSupport.DELAYED_ACTIONS.add(new Removal((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)actualExtra));
    }

    @ZenMethod
    public static void remove(IOreDictEntry input, ILiquidStack inputFluid, IOreDictEntry extra) {
        OreDictDefinition actualInput = CTSupport.fromOreEntry(input);
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        OreDictDefinition actualExtra = CTSupport.fromOreEntry(extra);
        CTSupport.DELAYED_ACTIONS.add(new Removal((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)actualExtra));
    }

    @ZenMethod
    public static void remove(IItemStack input, ILiquidStack inputFluid) {
        ItemDefinition actualInput = ItemDefinition.of((ItemStack)CTSupport.toNative(input));
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        CTSupport.DELAYED_ACTIONS.add(new Removal((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)ItemDefinition.EMPTY));
    }

    @ZenMethod
    public static void remove(IOreDictEntry input, ILiquidStack inputFluid) {
        OreDictDefinition actualInput = CTSupport.fromOreEntry(input);
        Fluid actualInputFluid = CTSupport.toNative(inputFluid).getFluid();
        CTSupport.DELAYED_ACTIONS.add(new Removal((ProcessingInput)actualInput, actualInputFluid, (ProcessingInput)ItemDefinition.EMPTY));
    }

    @ZenMethod
    public static void remove(@Nonnull String identifier) {
        CTSupport.DELAYED_ACTIONS.add(new CTSupport.RemovalByIdentifier(CTVessel.getManager(), new ResourceLocation(identifier)));
    }

    @ZenMethod
    public static void removeAll() {
        CTSupport.DELAYED_ACTIONS.add(new CTSupport.BulkRemoval(CTVessel::getManager));
    }

    private static CuisineProcessingRecipeManager<Vessel> getManager() {
        return Processing.VESSEL;
    }

    private static final class Removal
    implements IAction {
        private final ProcessingInput actualInput;
        private final Fluid actualInputFluid;
        private final ProcessingInput actualExtra;

        Removal(ProcessingInput actualInput, Fluid actualInputFluid, ProcessingInput actualExtra) {
            this.actualInput = actualInput;
            this.actualInputFluid = actualInputFluid;
            this.actualExtra = actualExtra;
        }

        public void apply() {
            CTVessel.getManager().remove(new Vessel(new ResourceLocation("crafttweaker"), this.actualInput, this.actualInputFluid, ItemDefinition.EMPTY, null, this.actualExtra));
        }

        public String describe() {
            return String.format("Remove all Cuisine Vessel recipes that has input of %s, %s and %s", this.actualInput, this.actualInputFluid, this.actualExtra);
        }
    }

    private static final class Addition
    extends CTSupport.Addition {
        private final ProcessingInput actualInput;
        private final Fluid actualInputFluid;
        private final ProcessingInput actualExtra;
        private final ItemDefinition actualOutput;
        private final FluidStack actualOutputFluid;

        Addition(ProcessingInput actualInput, Fluid actualInputFluid, ProcessingInput actualExtra, ItemDefinition actualOutput, FluidStack actualOutputFluid) {
            super(actualInput, actualInputFluid, actualExtra, actualOutput, actualOutputFluid);
            this.actualInput = actualInput;
            this.actualInputFluid = actualInputFluid;
            this.actualExtra = actualExtra;
            this.actualOutput = actualOutput;
            this.actualOutputFluid = actualOutputFluid;
        }

        public void apply() {
            CTVessel.getManager().add(new Vessel(this.locator, this.actualInput, this.actualInputFluid, this.actualOutput, this.actualOutputFluid, this.actualExtra));
        }

        public String describe() {
            return String.format("Add Cuisine Vessel recipe: %s + %s + %s -> %s + %s", this.actualInput, this.actualInputFluid, this.actualExtra, this.actualOutput, this.actualOutputFluid);
        }
    }
}

