/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.api.process.CuisineProcessingRecipe;
import snownee.cuisine.api.process.CuisineProcessingRecipeManager;
import snownee.cuisine.plugins.crafttweaker.CTIngredientInput;
import snownee.kiwi.IModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.util.definition.ItemDefinition;
import snownee.kiwi.util.definition.OreDictDefinition;

@KiwiModule(modid="cuisine", name="crafttweaker", dependency="crafttweaker")
public final class CTSupport
implements IModule {
    static final String MODID = "crafttweaker";
    static ArrayList<IAction> DELAYED_ACTIONS = new ArrayList(16);

    public void postInit() {
        DELAYED_ACTIONS.forEach(CraftTweakerAPI::apply);
        DELAYED_ACTIONS.clear();
    }

    static ResourceLocation fromUserInputOrGenerate(Object ... inputs) {
        return new ResourceLocation(MODID, Integer.toString(Objects.hash(inputs)));
    }

    static ProcessingInput fromIngredient(IIngredient ingredient) {
        return ingredient == null ? ItemDefinition.EMPTY : new CTIngredientInput(ingredient);
    }

    static OreDictDefinition fromOreEntry(IOreDictEntry entry) {
        return entry == null ? OreDictDefinition.EMPTY : OreDictDefinition.of((String)entry.getName(), (int)entry.getAmount());
    }

    static ItemStack toNative(@Nullable IItemStack ctDefinition) {
        return CraftTweakerMC.getItemStack((IItemStack)ctDefinition);
    }

    static Stream<ItemStack> toNatives(@Nullable IItemStack ctDefinition) {
        ItemStack raw = CTSupport.toNative(ctDefinition);
        if (raw.func_77960_j() == Short.MAX_VALUE) {
            NonNullList items = NonNullList.func_191196_a();
            raw.func_77973_b().func_150895_a(raw.func_77973_b().func_77640_w(), items);
            return items.stream();
        }
        return Collections.singletonList(raw).stream();
    }

    static FluidStack toNative(ILiquidStack ctDefinition) {
        return CraftTweakerMC.getLiquidStack((ILiquidStack)ctDefinition);
    }

    static Block toNative(IBlockDefinition ctDefinition) {
        return CraftTweakerMC.getBlock((IBlockDefinition)ctDefinition);
    }

    static IBlockState toNative(crafttweaker.api.block.IBlockState ctDefinition) {
        return CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)ctDefinition);
    }

    static final class BulkRemoval
    implements IAction {
        private final Supplier<? extends CuisineProcessingRecipeManager<? extends CuisineProcessingRecipe>> managerAccess;

        BulkRemoval(Supplier<? extends CuisineProcessingRecipeManager<? extends CuisineProcessingRecipe>> managerAccess) {
            this.managerAccess = Objects.requireNonNull(managerAccess);
        }

        public void apply() {
            this.managerAccess.get().removeAll();
        }

        public String describe() {
            return "Removing all recipes from " + this.managerAccess.get();
        }
    }

    static class RemovalByIdentifier
    implements IAction {
        final CuisineProcessingRecipeManager<?> manager;
        final ResourceLocation locator;

        RemovalByIdentifier(CuisineProcessingRecipeManager<?> manager, ResourceLocation locator) {
            this.manager = manager;
            this.locator = locator;
        }

        public void apply() {
            this.manager.remove(this.locator);
        }

        public String describe() {
            return null;
        }
    }

    static abstract class Addition
    implements IAction {
        final ResourceLocation locator;

        Addition(Object input0, Object ... moreInputs) {
            this.locator = CTSupport.fromUserInputOrGenerate(input0, moreInputs);
        }
    }
}

