/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import snownee.cuisine.api.process.CuisineProcessingRecipeManager;
import snownee.cuisine.api.process.Grinding;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.plugins.crafttweaker.CTSupport;
import snownee.kiwi.crafting.input.ProcessingInput;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.cuisine.Mortar")
@ZenRegister
public class CTMortar {
    @ZenMethod
    public static void add(IIngredient[] inputs, IItemStack output, int step) {
        List<ProcessingInput> list = Arrays.stream(inputs).map(CTSupport::fromIngredient).collect(Collectors.toList());
        CTSupport.DELAYED_ACTIONS.add(new Addition(list, CraftTweakerMC.getItemStack((IItemStack)output), step));
    }

    @ZenMethod
    public static void remove(IItemStack[] inputs) {
        CTSupport.DELAYED_ACTIONS.add(new Removal(Arrays.stream(inputs).map(CTSupport::toNative).collect(Collectors.toList())));
    }

    @ZenMethod
    public static void removeByOutput(@Nonnull IIngredient output) {
        CTSupport.DELAYED_ACTIONS.add(new RemovalByOutput(output));
    }

    @ZenMethod
    public static void remove(@Nonnull String identifier) {
        CTSupport.DELAYED_ACTIONS.add(new CTSupport.RemovalByIdentifier(CTMortar.getManager(), new ResourceLocation(identifier)));
    }

    @ZenMethod
    public static void removeAll() {
        CTSupport.DELAYED_ACTIONS.add(new CTSupport.BulkRemoval(CTMortar::getManager));
    }

    private static CuisineProcessingRecipeManager<Grinding> getManager() {
        return Processing.GRINDING;
    }

    private static final class RemovalByOutput
    implements IAction {
        final IIngredient output;

        RemovalByOutput(IIngredient output) {
            this.output = output;
        }

        public void apply() {
            CTMortar.getManager().removeIf(r -> this.output.matches(CraftTweakerMC.getIItemStack((ItemStack)r.getOutput())));
        }

        public String describe() {
            return null;
        }
    }

    private static final class Removal
    implements IAction {
        final List<ItemStack> inputs;

        Removal(List<ItemStack> inputs) {
            this.inputs = inputs;
        }

        public void apply() {
            CTMortar.getManager().remove(this.inputs.toArray());
        }

        public String describe() {
            return String.format("Remove Cuisine Mortar recipe that has input of %s", this.inputs);
        }
    }

    private static final class Addition
    extends CTSupport.Addition
    implements IAction {
        final List<ProcessingInput> inputs;
        final ItemStack output;
        final int step;

        Addition(List<ProcessingInput> inputs, ItemStack output, int step) {
            super(inputs, output, step);
            this.inputs = inputs;
            this.output = output;
            this.step = step;
        }

        public void apply() {
            CTMortar.getManager().add(new Grinding(this.locator, this.inputs, this.output, this.step));
        }

        public String describe() {
            return String.format("Add Cuisine Mortar recipe: %s -> %s", this.inputs, this.output);
        }
    }
}

