/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.api.process.CuisineProcessingRecipeManager;
import snownee.cuisine.api.process.Milling;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.plugins.crafttweaker.CTSupport;
import snownee.kiwi.crafting.input.ProcessingInput;
import snownee.kiwi.util.definition.OreDictDefinition;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.cuisine.Mill")
@ZenRegister
public class CTMill {
    @ZenMethod
    public static void add(IIngredient input, ILiquidStack inputFluid, IItemStack output, ILiquidStack outputFluid) {
        ProcessingInput actualInput = CTSupport.fromIngredient(input);
        ItemStack actualOutput = CTSupport.toNative(output);
        FluidStack actualInputFluid = CTSupport.toNative(inputFluid);
        FluidStack actualOutputFluid = CTSupport.toNative(outputFluid);
        CTSupport.DELAYED_ACTIONS.add(new Addition(actualInput, actualInputFluid, actualOutput, actualOutputFluid));
    }

    @ZenMethod
    public static void remove(IItemStack input, ILiquidStack inputFluid) {
        ItemStack actualInput = CTSupport.toNative(input);
        FluidStack actualInputFluid = CTSupport.toNative(inputFluid);
        CTSupport.DELAYED_ACTIONS.add(new ItemBasedRemoval(actualInput, actualInputFluid));
    }

    @ZenMethod
    public static void remove(IOreDictEntry input, ILiquidStack inputFluid) {
        OreDictDefinition actualInput = OreDictDefinition.of((String)input.getName(), (int)input.getAmount());
        FluidStack actualInputFluid = CTSupport.toNative(inputFluid);
        CTSupport.DELAYED_ACTIONS.add(new OreDictBasedRemoval(actualInput, actualInputFluid));
    }

    @ZenMethod
    public static void remove(@Nonnull String identifier) {
        CTSupport.DELAYED_ACTIONS.add(new CTSupport.RemovalByIdentifier(CTMill.getManager(), new ResourceLocation(identifier)));
    }

    @ZenMethod
    public static void removeAll() {
        CTSupport.DELAYED_ACTIONS.add(new CTSupport.BulkRemoval(CTMill::getManager));
    }

    private static CuisineProcessingRecipeManager<Milling> getManager() {
        return Processing.MILLING;
    }

    private static class OreDictBasedRemoval
    implements IAction {
        private final OreDictDefinition actualInput;
        private final FluidStack actualInputFluid;

        OreDictBasedRemoval(OreDictDefinition actualInput, FluidStack actualInputFluid) {
            this.actualInput = actualInput;
            this.actualInputFluid = actualInputFluid;
        }

        public void apply() {
            CTMill.getManager().remove(new Milling(new ResourceLocation("crafttweaker"), (ProcessingInput)this.actualInput, ItemStack.field_190927_a, this.actualInputFluid, null));
        }

        public String describe() {
            return null;
        }
    }

    private static final class ItemBasedRemoval
    implements IAction {
        private final ItemStack actualInput;
        private final FluidStack actualInputFluid;

        ItemBasedRemoval(ItemStack actualInput, FluidStack actualInputFluid) {
            this.actualInput = actualInput;
            this.actualInputFluid = actualInputFluid;
        }

        public void apply() {
            CTMill.getManager().remove(new Milling(new ResourceLocation("crafttweaker"), this.actualInput, ItemStack.field_190927_a, this.actualInputFluid, null));
        }

        public String describe() {
            return String.format("Remove all Cuisine milling recipes that has input item of %s and input fluid of %s", this.actualInput, this.actualInputFluid);
        }
    }

    private static final class Addition
    extends CTSupport.Addition {
        private final ProcessingInput actualInput;
        private final FluidStack actualInputFluid;
        private final ItemStack actualOutput;
        private final FluidStack actualOutputFluid;

        Addition(ProcessingInput actualInput, FluidStack actualInputFluid, ItemStack actualOutput, FluidStack actualOutputFluid) {
            super(actualInput, actualInputFluid, actualOutput, actualOutputFluid);
            this.actualInput = actualInput;
            this.actualInputFluid = actualInputFluid;
            this.actualOutput = actualOutput;
            this.actualOutputFluid = actualOutputFluid;
        }

        public void apply() {
            CTMill.getManager().add(new Milling(this.locator, this.actualInput, this.actualOutput, this.actualInputFluid, this.actualOutputFluid));
        }

        public String describe() {
            return String.format("Add Cuisine Mill recipe: %s + %s -> %s + %s", this.actualInput, this.actualInputFluid, this.actualOutput, this.actualOutputFluid);
        }
    }
}

