/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.crafttweaker;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import snownee.cuisine.plugins.crafttweaker.CTSupport;
import snownee.kiwi.crafting.input.ProcessingInput;

final class CTIngredientInput
implements ProcessingInput {
    private final IIngredient ingredient;

    CTIngredientInput(IIngredient ingredient) {
        this.ingredient = ingredient;
    }

    @Nonnull
    public List<ItemStack> examples() {
        return Optional.ofNullable(this.ingredient.getItems()).orElse(Collections.emptyList()).stream().flatMap(CTSupport::toNatives).collect(Collectors.toList());
    }

    public boolean matches(@Nonnull ItemStack itemStack) {
        return this.ingredient.matches(CraftTweakerMC.getIItemStack((ItemStack)itemStack));
    }

    public boolean isEmpty() {
        return this.ingredient != null && this.ingredient.getAmount() > 0;
    }

    public int count() {
        return this.ingredient.getAmount();
    }
}

