/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import snownee.cuisine.plugins.crafttweaker.CTSupport;
import snownee.cuisine.tiles.TileBasinHeatable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.cuisine.HeatSources")
@ZenRegister
public final class CTHeatSources {
    private CTHeatSources() {
    }

    @ZenMethod
    public static void add(int heatValue, IBlockDefinition ... blocks) {
        CTSupport.DELAYED_ACTIONS.add(new BlockAddition(heatValue, Arrays.asList(blocks).stream().map(CTSupport::toNative).collect(Collectors.toList())));
    }

    @ZenMethod
    public static void add(int heatValue, crafttweaker.api.block.IBlockState ... states) {
        CTSupport.DELAYED_ACTIONS.add(new BlockStateAddition(heatValue, Arrays.asList(states).stream().map(CTSupport::toNative).collect(Collectors.toList())));
    }

    @ZenMethod
    public static void removeAll() {
        CTSupport.DELAYED_ACTIONS.add(new BulkRemoval());
    }

    private static final class BulkRemoval
    implements IAction {
        private BulkRemoval() {
        }

        public void apply() {
            TileBasinHeatable.BLOCK_HEAT_SOURCES.clear();
            TileBasinHeatable.STATE_HEAT_SOURCES.clear();
            TileBasinHeatable.BLOCK_TO_ITEM.clear();
            TileBasinHeatable.STATE_TO_ITEM.clear();
        }

        public String describe() {
            return null;
        }
    }

    private static final class BlockStateAddition
    implements IAction {
        private final int heatValue;
        private final Collection<IBlockState> states;

        private BlockStateAddition(int heatValue, Collection<IBlockState> states) {
            this.heatValue = heatValue;
            this.states = states;
        }

        public void apply() {
            this.states.stream().forEach($ -> {
                TileBasinHeatable.STATE_HEAT_SOURCES.put((IBlockState)$, this.heatValue);
                Block block = $.func_177230_c();
                Item item = Item.func_150898_a((Block)block);
                if (item != Items.field_190931_a) {
                    ItemStack stack = new ItemStack(item, 1, block.func_180651_a($));
                    TileBasinHeatable.STATE_TO_ITEM.put((IBlockState)$, stack);
                }
            });
        }

        public String describe() {
            return null;
        }
    }

    private static final class BlockAddition
    implements IAction {
        private final int heatValue;
        private final Collection<Block> blocks;

        private BlockAddition(int heatValue, Collection<Block> blocks) {
            this.heatValue = heatValue;
            this.blocks = blocks;
        }

        public void apply() {
            this.blocks.stream().forEach(block -> {
                TileBasinHeatable.BLOCK_HEAT_SOURCES.put((Block)block, this.heatValue);
                Item item = Item.func_150898_a((Block)block);
                if (item != Items.field_190931_a) {
                    ItemStack stack = new ItemStack(item, 1, block.func_180651_a(block.func_176223_P()));
                    TileBasinHeatable.BLOCK_TO_ITEM.put((Block)block, stack);
                }
            });
        }

        public String describe() {
            return null;
        }
    }
}

