/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import java.util.Optional;
import snownee.cuisine.internal.food.Drink;
import snownee.cuisine.plugins.crafttweaker.CTSupport;
import snownee.kiwi.crafting.input.ProcessingInput;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.cuisine.Drink")
@ZenRegister
public final class CTDrink {
    private CTDrink() {
    }

    @ZenMethod
    public static void addSpecialItem(String drinkType, IIngredient ingredient) {
        new Addition(drinkType, CTSupport.fromIngredient(ingredient)).apply();
    }

    @ZenMethod
    public static void removeAllSpecialItems(String drinkType) {
        new Removal(drinkType).apply();
    }

    @ZenMethod
    public static void removeAllSpecialItems() {
        new BulkRemoval().apply();
    }

    @ZenMethod
    public static Drink.DrinkType[] getAllDrinkTypes() {
        return Drink.DrinkType.DRINK_TYPES.keySet().toArray(new Drink.DrinkType[0]);
    }

    private static Drink.DrinkType get(String name) {
        return Optional.ofNullable(Drink.DrinkType.get(name)).orElse(Drink.DrinkType.NORMAL);
    }

    private static final class BulkRemoval
    implements IAction {
        private BulkRemoval() {
        }

        public void apply() {
            Drink.Builder.FEATURE_INPUTS.clear();
        }

        public String describe() {
            return null;
        }
    }

    private static final class Removal
    implements IAction {
        private final String drinkType;

        private Removal(String drinkType) {
            this.drinkType = drinkType;
        }

        public void apply() {
            Drink.DrinkType type = CTDrink.get(this.drinkType);
            Drink.Builder.FEATURE_INPUTS.values().removeIf(type::equals);
        }

        public String describe() {
            return null;
        }
    }

    private static final class Addition
    implements IAction {
        private final String drinkType;
        private final ProcessingInput ingredient;

        private Addition(String drinkType, ProcessingInput ingredient) {
            this.drinkType = drinkType;
            this.ingredient = ingredient;
        }

        public void apply() {
            Drink.DrinkType type = CTDrink.get(this.drinkType);
            if (type == Drink.DrinkType.NORMAL) {
                throw new NullPointerException("Cannot find drink type or drink type is the default one.");
            }
            Drink.Builder.FEATURE_INPUTS.put(this.ingredient, type);
        }

        public String describe() {
            return null;
        }
    }
}

