/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.api.process.BasinInteracting;
import snownee.cuisine.api.process.CuisineProcessingRecipeManager;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.api.process.prefab.SimpleThrowing;
import snownee.cuisine.plugins.crafttweaker.CTSupport;
import snownee.kiwi.crafting.input.ProcessingInput;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.cuisine.BasinThrowing")
@ZenRegister
public final class CTBasinThrowing {
    private CTBasinThrowing() {
    }

    @ZenMethod
    public static void add(IIngredient input, ILiquidStack inputFluid, IItemStack output) {
        ProcessingInput actualInput = CTSupport.fromIngredient(input);
        FluidStack actualInputFluid = CTSupport.toNative(inputFluid);
        ItemStack actualOutput = CTSupport.toNative(output);
        CTSupport.DELAYED_ACTIONS.add(new Addition(actualInput, actualInputFluid, actualOutput));
    }

    @ZenMethod
    public static void remove(IItemStack input, ILiquidStack inputFluid) {
        CTSupport.DELAYED_ACTIONS.add(new RemovalByItem(CTSupport.toNative(input), CTSupport.toNative(inputFluid)));
    }

    @ZenMethod
    public static void remove(@Nonnull String identifier) {
        CTSupport.DELAYED_ACTIONS.add(new CTSupport.RemovalByIdentifier(CTBasinThrowing.getManager(), new ResourceLocation(identifier)));
    }

    @ZenMethod
    public static void removeAll() {
        CTSupport.DELAYED_ACTIONS.add(new CTSupport.BulkRemoval(CTBasinThrowing::getManager));
    }

    private static CuisineProcessingRecipeManager<BasinInteracting> getManager() {
        return Processing.BASIN_THROWING;
    }

    private static final class RemovalByItem
    implements IAction {
        private final ItemStack input;
        private final FluidStack inputFluid;

        RemovalByItem(ItemStack input, FluidStack inputFluid) {
            this.input = input;
            this.inputFluid = inputFluid;
        }

        public void apply() {
            CTBasinThrowing.getManager().remove(this.input, this.inputFluid);
        }

        public String describe() {
            return null;
        }
    }

    private static final class Addition
    extends CTSupport.Addition
    implements IAction {
        private final ProcessingInput input;
        private final FluidStack inputFluid;
        private final ItemStack output;

        private Addition(ProcessingInput input, FluidStack inputFluid, ItemStack output) {
            super(input, inputFluid, output);
            this.input = input;
            this.inputFluid = inputFluid;
            this.output = output;
        }

        public void apply() {
            CTBasinThrowing.getManager().add(new SimpleThrowing(this.locator, this.input, this.inputFluid, this.output));
        }

        public String describe() {
            return null;
        }
    }
}

