/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import snownee.cuisine.api.process.Boiling;
import snownee.cuisine.api.process.CuisineProcessingRecipeManager;
import snownee.cuisine.api.process.Processing;
import snownee.cuisine.api.process.prefab.DistillationBoiling;
import snownee.cuisine.plugins.crafttweaker.CTSupport;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.cuisine.BasinHeating")
@ZenRegister
public final class CTBasinHeating {
    private CTBasinHeating() {
    }

    @ZenMethod
    public static void add(ILiquidStack input, IItemStack output, @Optional(valueLong=1L) int heatValue) {
        FluidStack actualInput = CTSupport.toNative(input);
        ItemStack actualOutput = CTSupport.toNative(output);
        CTSupport.DELAYED_ACTIONS.add(new Addition(actualInput, actualOutput, heatValue));
    }

    @ZenMethod
    public static void remove(ILiquidStack input) {
        CTSupport.DELAYED_ACTIONS.add(new Removal(CTSupport.toNative(input)));
    }

    @ZenMethod
    public static void remove(@Nonnull String identifier) {
        CTSupport.DELAYED_ACTIONS.add(new CTSupport.RemovalByIdentifier(CTBasinHeating.getManager(), new ResourceLocation(identifier)));
    }

    @ZenMethod
    public static void removeAll() {
        CTSupport.DELAYED_ACTIONS.add(new CTSupport.BulkRemoval(CTBasinHeating::getManager));
    }

    private static CuisineProcessingRecipeManager<Boiling> getManager() {
        return Processing.BOILING;
    }

    private static final class Removal
    implements IAction {
        private final FluidStack input;

        private Removal(FluidStack input) {
            this.input = input;
        }

        public void apply() {
            CTBasinHeating.getManager().remove(new Object[]{this.input});
        }

        public String describe() {
            return null;
        }
    }

    private static final class Addition
    extends CTSupport.Addition
    implements IAction {
        private final FluidStack input;
        private final ItemStack output;
        private final int heatValue;

        private Addition(FluidStack input, ItemStack output, int heatValue) {
            super(input, output, heatValue);
            this.input = input;
            this.output = output;
            this.heatValue = heatValue;
        }

        public void apply() {
            CTBasinHeating.getManager().add(new DistillationBoiling(this.locator, this.input, this.output, this.heatValue));
        }

        public String describe() {
            return null;
        }
    }
}

