/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.plugins;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.cuisine.CuisineRegistry;
import snownee.cuisine.api.CompositeFood;
import snownee.cuisine.api.CulinaryHub;
import snownee.cuisine.api.Form;
import snownee.cuisine.api.Ingredient;
import snownee.cuisine.api.events.ConsumeCompositeFoodEvent;
import snownee.cuisine.api.events.SpiceBottleContentConsumedEvent;
import snownee.cuisine.internal.food.Drink;
import snownee.cuisine.tiles.TileBasinHeatable;
import snownee.kiwi.IModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.util.definition.ItemDefinition;
import toughasnails.api.TANBlocks;
import toughasnails.api.TANCapabilities;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.ISyncedOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.thirst.WaterType;

@KiwiModule(modid="cuisine", name="toughasnails", dependency="toughasnails", optional=true)
public class TANCompat
implements IModule {
    public static Potion heat_resistance = TANPotions.heat_resistance;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (int i = 0; i < 8; ++i) {
            IBlockState state = TANBlocks.campfire.func_176203_a(i << 1 | 1);
            TileBasinHeatable.STATE_HEAT_SOURCES.put(state, 3);
            if (i != 0) continue;
            TileBasinHeatable.STATE_TO_ITEM.put(state, new ItemStack(TANBlocks.campfire));
        }
        IBlockState state = TANBlocks.temperature_coil.func_176203_a(9);
        TileBasinHeatable.registerHeatSource(4, state, new ItemStack(TANBlocks.temperature_coil, 1, 1));
        Item juice = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("toughasnails", "fruit_juice"));
        if (juice != null) {
            juice.func_77642_a(Items.field_151069_bo);
            CulinaryHub.API_INSTANCE.registerMapping(ItemDefinition.of((Item)juice, (int)0), new Ingredient(CulinaryHub.CommonMaterials.APPLE, Form.JUICE));
            CulinaryHub.API_INSTANCE.registerMapping(ItemDefinition.of((Item)juice, (int)1), new Ingredient(CulinaryHub.CommonMaterials.BEETROOT, Form.JUICE));
            CulinaryHub.API_INSTANCE.registerMapping(ItemDefinition.of((Item)juice, (int)2), new Ingredient(CulinaryHub.CommonMaterials.CACTUS, Form.JUICE));
            CulinaryHub.API_INSTANCE.registerMapping(ItemDefinition.of((Item)juice, (int)3), new Ingredient(CulinaryHub.CommonMaterials.CARROT, Form.JUICE));
            CulinaryHub.API_INSTANCE.registerMapping(ItemDefinition.of((Item)juice, (int)4), new Ingredient(CulinaryHub.CommonMaterials.CHORUS_FRUIT, Form.JUICE));
            CulinaryHub.API_INSTANCE.registerMapping(ItemDefinition.of((Item)juice, (int)6), new Ingredient(CulinaryHub.CommonMaterials.GOLDEN_APPLE, Form.JUICE));
            CulinaryHub.API_INSTANCE.registerMapping(ItemDefinition.of((Item)juice, (int)7), new Ingredient(CulinaryHub.CommonMaterials.GOLDEN_CARROT, Form.JUICE));
            CulinaryHub.API_INSTANCE.registerMapping(ItemDefinition.of((Item)juice, (int)8), new Ingredient(CulinaryHub.CommonMaterials.MELON, Form.JUICE));
            CulinaryHub.API_INSTANCE.registerMapping(ItemDefinition.of((Item)juice, (int)9), new Ingredient(CulinaryHub.CommonMaterials.PUMPKIN, Form.JUICE));
        }
    }

    @SubscribeEvent
    public void onDrinkingSomething(ConsumeCompositeFoodEvent.Post event) {
        CompositeFood food = event.getFood();
        if (food.getKeywords().contains("drink")) {
            IThirst handler;
            if (TANCompat.enableThirst() && event.getConsumer().hasCapability(TANCapabilities.THIRST, null)) {
                handler = (IThirst)event.getConsumer().getCapability(TANCapabilities.THIRST, null);
                handler.setExhaustion(0.0f);
                handler.addStats(food.getFoodLevel() * 2 + food.getIngredients().size() * 2, food.getSaturationModifier());
            }
            if (TANCompat.enableTemperature() && event.getConsumer().hasCapability(TANCapabilities.TEMPERATURE, null) && food.getClass() == Drink.class && ((Drink)food).getDrinkType() == Drink.DrinkType.SMOOTHIE) {
                handler = (ITemperature)event.getConsumer().getCapability(TANCapabilities.TEMPERATURE, null);
                handler.addTemperature(new Temperature(-4));
                if (TANPotions.heat_resistance != null) {
                    event.getConsumer().func_70690_d(new PotionEffect(TANPotions.heat_resistance, 300));
                }
            }
        }
    }

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        FluidStack fluid;
        Ingredient ingredient;
        IFluidHandlerItem fluidHandlerItem;
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        if (event.getItem().func_77973_b() == CuisineRegistry.BOTTLE && TANCompat.enableThirst() && event.getEntityLiving().hasCapability(TANCapabilities.THIRST, null) && (fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)event.getItem(), (int)1))) != null && (ingredient = CulinaryHub.API_INSTANCE.findIngredient(fluid = fluidHandlerItem.drain(Integer.MAX_VALUE, false))) != null) {
            IThirst handler = (IThirst)event.getEntityLiving().getCapability(TANCapabilities.THIRST, null);
            handler.setExhaustion(0.0f);
            handler.addStats((int)(ingredient.getFoodLevel() * 4.0), 0.4f + ingredient.getSaturationModifier());
        }
    }

    public static boolean enableTemperature() {
        return SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_TEMPERATURE);
    }

    public static boolean enableThirst() {
        return SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_THIRST);
    }

    public static boolean isPlayerThirsty(EntityPlayer player) {
        IThirst thirst = (IThirst)player.getCapability(TANCapabilities.THIRST, null);
        if (thirst == null) {
            return false;
        }
        return thirst.getThirst() < 20;
    }

    @SubscribeEvent
    public void onSpiceBottleUsed(SpiceBottleContentConsumedEvent event) {
        WaterType waterType = null;
        if (event.getContent() instanceof FluidStack) {
            Fluid fluid = ((FluidStack)event.getContent()).getFluid();
            if (fluid == FluidRegistry.WATER) {
                waterType = WaterType.NORMAL;
            } else if (fluid.getName().equals("purified_water")) {
                waterType = WaterType.PURIFIED;
            }
        }
        if (waterType == null) {
            return;
        }
        IThirst handler = (IThirst)event.getEntityLiving().getCapability(TANCapabilities.THIRST, null);
        if (TANCompat.enableThirst() && handler != null) {
            World world = event.getWorld();
            handler.addStats(waterType.getThirst(), waterType.getHydration());
            if (!world.field_72995_K && world.field_73012_v.nextFloat() < waterType.getPoisonChance()) {
                event.getEntityLiving().func_70690_d(new PotionEffect(TANPotions.thirst, 600));
            }
        }
    }
}

