/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.network;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.cuisine.Cuisine;
import snownee.cuisine.tiles.FuelHeatHandler;
import snownee.cuisine.tiles.TileJar;
import snownee.cuisine.tiles.TileWok;
import snownee.kiwi.network.PacketMod;

public class PacketCustomEvent
implements PacketMod {
    private short event;
    private float posX;
    private float posY;
    private float posZ;
    private int extraData = 0;

    public PacketCustomEvent() {
    }

    public PacketCustomEvent(int event, Vec3d particlePos) {
        this(event, (float)particlePos.field_72450_a, (float)particlePos.field_72448_b, (float)particlePos.field_72449_c);
    }

    public PacketCustomEvent(int event, float x, float y, float z) {
        this.event = (short)event;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public PacketCustomEvent(int event, BlockPos pos) {
        this(event, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public PacketCustomEvent(int event, BlockPos pos, int extra) {
        this(event, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.extraData = extra;
    }

    public void writeDataTo(ByteBuf buffer) {
        buffer.writeShort((int)this.event);
        buffer.writeFloat(this.posX);
        buffer.writeFloat(this.posY);
        buffer.writeFloat(this.posZ);
        buffer.writeInt(this.extraData);
    }

    public void readDataFrom(ByteBuf buffer) {
        this.event = buffer.readShort();
        this.posX = buffer.readFloat();
        this.posY = buffer.readFloat();
        this.posZ = buffer.readFloat();
        this.extraData = buffer.readInt();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient(EntityPlayerSP player) {
        switch (this.event) {
            case 2: {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                double x = (double)this.posX + 0.5 + world.field_73012_v.nextGaussian() * 0.2;
                double z = (double)this.posZ + 0.5 + world.field_73012_v.nextGaussian() * 0.2;
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, x, (double)this.posY + 0.25, z, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)world.func_180495_p(new BlockPos((double)this.posX, (double)this.posY, (double)this.posZ)))});
                break;
            }
            case 3: {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                Random rand = world.field_73012_v;
                TileEntity te = world.func_175625_s(new BlockPos((double)this.posX, (double)this.posY, (double)this.posZ));
                if (te instanceof TileWok) {
                    ((TileWok)te).actionCycle = (byte)(((TileWok)te).actionCycle + 1);
                    FuelHeatHandler handler = ((TileWok)te).getHeatHandler();
                    if (handler instanceof FuelHeatHandler) {
                        int level = handler.getLevel();
                        for (int k = 0; k < level * 2; ++k) {
                            double x = (double)this.posX + 0.5 + rand.nextGaussian() * 0.2;
                            double z = (double)this.posZ + 0.5 + rand.nextGaussian() * 0.2;
                            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, x, (double)this.posY + 0.25, z, 0.0, 0.1, 0.0, new int[0]);
                        }
                        if (level > 0) {
                            world.func_184134_a((double)this.posX + 0.5, (double)this.posY + 0.25, (double)this.posZ + 0.5, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.4f + rand.nextFloat() * 0.2f * (float)level, 0.7f + rand.nextFloat() * 0.1f * (float)level, false);
                        }
                    }
                }
            }
            case 5: {
                TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos((double)this.posX, (double)this.posY, (double)this.posZ));
                if (!(tile instanceof TileJar)) break;
                ((TileJar)tile).forceSetWorkingStatus(this.extraData == 1);
                break;
            }
            default: {
                Cuisine.logger.warn("Undefined event: {} {}, {}, {} {}. Skipping", (Object)this.event, (Object)Float.valueOf(this.posX), (Object)Float.valueOf(this.posY), (Object)Float.valueOf(this.posZ), (Object)this.extraData);
            }
        }
    }

    public void handleServer(EntityPlayerMP player) {
    }
}

