/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.library;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import snownee.cuisine.library.IntObjectBiPredicate;

public class FilterItemHandler
implements IItemHandler {
    private final IItemHandler parent;
    private final IntObjectBiPredicate<ItemStack> predicate;

    public FilterItemHandler(IItemHandler parent, IntObjectBiPredicate<ItemStack> predicate) {
        this.parent = parent;
        this.predicate = predicate;
    }

    public int getSlots() {
        return this.parent.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.parent.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.predicate.test(slot, stack) ? this.parent.insertItem(slot, stack, simulate) : stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.parent.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.parent.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.predicate.test(slot, stack);
    }
}

