/*
 * Decompiled with CFR 0.152.
 */
package snownee.cuisine.library;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FilterFluidHandler
implements IFluidHandler {
    private final IFluidHandler parent;
    private final Predicate<FluidStack> validator;

    public FilterFluidHandler(IFluidHandler parent, Predicate<FluidStack> validator) {
        this.parent = parent;
        this.validator = validator;
    }

    public IFluidTankProperties[] getTankProperties() {
        IFluidTankProperties[] parents = this.parent.getTankProperties();
        IFluidTankProperties[] properties = new IFluidTankProperties[parents.length];
        for (int i = 0; i < parents.length; ++i) {
            properties[i] = new FilterFluidTankProperties(parents[i]);
        }
        return properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.validator.test(resource)) {
            return this.parent.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.parent.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.parent.drain(maxDrain, doDrain);
    }

    private final class FilterFluidTankProperties
    implements IFluidTankProperties {
        private final IFluidTankProperties parent;

        private FilterFluidTankProperties(IFluidTankProperties parent) {
            this.parent = parent;
        }

        @Nullable
        public FluidStack getContents() {
            return this.parent.getContents();
        }

        public int getCapacity() {
            return this.parent.getCapacity();
        }

        public boolean canFill() {
            return this.parent.canFill();
        }

        public boolean canDrain() {
            return this.parent.canDrain();
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return FilterFluidHandler.this.validator.test(fluidStack) && this.parent.canFillFluidType(fluidStack);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return this.parent.canDrainFluidType(fluidStack);
        }
    }
}

